% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDN.R
\name{buildnetworks}
\alias{buildnetworks}
\title{Generating Network Matrix}
\usage{
buildnetworks(x, k1, del = 0)
}
\arguments{
\item{x}{comorbidity data matrix with column correspond to ICD9 codes and row correspond to each patient}

\item{k1}{the cut off point between Diagnosis/Procedure A to another Diagnosis/Procedure B, it can be fix number, NULL and datecut}

\item{del}{number of character deleted for each name of the input}
}
\value{
Network Matrix
}
\description{
This function use data set with cut off information to create network matrix
}
\examples{
# Select a subset of data for toy example
comorbidity_data = comorbidity_data[c(1:10),]
survival_data = survival_data[c(1:10),]
k1 = datecut(comorbidity_data,survival_data[,1],survival_data[,2])
a = buildnetworks(comorbidity_data,k1)
}
