% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PDMIFLING.R
\name{PDMIFLING}
\alias{PDMIFLING}
\title{PDMIFLING}
\usage{
PDMIFLING(X, Y, Membership, NGfactors, NLfactors, Maxit = 100, tol = 0.001)
}
\arguments{
\item{X}{The (NT) times p design matrix, without an intercept where N=number of individuals, T=length of time series, p=number of explanatory variables.}

\item{Y}{The T times N panel of response where N=number of individuals, T=length of time series.}

\item{Membership}{A pre-specified group membership.}

\item{NGfactors}{A pre-specified number of common factors across groups (see example).}

\item{NLfactors}{A pre-specified number of factors in each groups (see example).}

\item{Maxit}{A maximum number of iterations in optimization. Default is 100.}

\item{tol}{Tolerance level of convergence. Default is 0.001.}
}
\value{
A list with the following components:
\itemize{
\item Coefficients: The estimated heterogeneous coefficients.
\item Lower05: Lower end (5\%) of the 90\% confidence interval of the regression coefficients.
\item Upper95: Upper end (95\%) of the 90\% confidence interval of the regression coefficients.
\item GlobalFactors: The estimated common factors across groups.
\item GlobalLoadings: The estimated factor loadings for the common factors.
\item GroupFactors: The estimated group-specific factors.
\item GroupLoadings: The estimated factor loadings for each group.
\item pval: p-value for testing hypothesis on heterogeneous coefficients.
\item Se: Standard error of the estimated regression coefficients.
}
}
\description{
Under a known group membership, this function estimates heterogeneous panel data models with interactive effects.
Together with the regression coefficients, this function estimates the unobserved common factor structures both for across/within groups.
}
\examples{
fit <- PDMIFLING(data4X,data4Y,data4LAB,2,c(2,2,2),30,0.1)
}
\references{
Ando, T. and Bai, J. (2015) Asset Pricing with a General Multifactor Structure Journal of Financial Econometrics, 13, 556-604.
}
