% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/returnsCRSPxts.R
\name{returnsCRSPxts}
\alias{returnsCRSPxts}
\title{Select CRSP Stocks Returns}
\usage{
returnsCRSPxts(stocksData)
}
\arguments{
\item{stocksData}{The data.table created by selectCRSPandSPGMI}
}
\value{
A multivariate xts object
}
\description{
Uses selectCRSPandSPGMI to select a subset of the stocksCRSP
data, and convert it to an xts object that contains the returns of a set
of stocks, along with those of the MktIndexCRSP and the Ret13WkBill.

NOTE:  For this function to work, the selectCRSPandSPGMI must include the 
the stockItems TickerLast, MktIndexCRSP and Ret13WkBill.
}
\examples{
data.table::setDTthreads(1)
library(PCRA)
library(xts)
library(data.table)
stockItems <- c("Date","TickerLast","CapGroupLast","Return","MktIndexCRSP",
               "Ret13WkBill")
dateRange <- c("1997-01-31","2002-12-31")
stocksDT <- selectCRSPandSPGMI("monthly",dateRange = dateRange, stockItems =
                                 stockItems, factorItems = NULL,
                                 outputType   = "data.table")
stocksDT <- stocksDT[CapGroupLast == "SmallCap"]
ret <- returnsCRSPxts(stocksDT)
tickers <- unique(stocksDT[,TickerLast])
tickers10 <- tickers[11:20]
colnames <- c(tickers10,"Market","RiskFree")
head(ret[,colnames],1)
}
