% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathEfrontRiskyMuCov.R
\name{mathEfrontRiskyMuCov}
\alias{mathEfrontRiskyMuCov}
\title{Efficient Frontier}
\usage{
mathEfrontRiskyMuCov(
  muRet,
  volRet,
  corrRet,
  npoints = 100,
  display = TRUE,
  efront.only = TRUE,
  values = FALSE,
  digits = NULL
)
}
\arguments{
\item{muRet}{Numeric vector of asset mean returns}

\item{volRet}{Numeric vector of asset standard deviations/volatilities}

\item{corrRet}{Correlation matrix of asset returns}

\item{npoints}{Integer number of points on efficient frontier, default 100}

\item{display}{Logical variable, default TRUE}

\item{efront.only}{Logical variable, default TRUE}

\item{values}{Logical variable, default = FALSE}

\item{digits}{Integer number of significant}
}
\value{
Plot of efficient frontier
}
\description{
Computes a frontier or efficient frontier based on user
specified mean vector and covariance matrix.  Default is to compute the
efficient frontier and plot it.  Optionally the mean and volatility values
of the frontier or efficient frontier is returned at a user specified number
of significant digits.
}
\details{
When efront.only = TRUE only the efficient frontier is computed,
and if FALSE the entire frontier is computed.  When value = TRUE the
efficient frontier mean and volatility values are returned, and when
value = FALSE these values are not returned.
}
\examples{
args(mathEfrontRiskyMuCov)
}
