% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cv.PCLasso}
\alias{plot.cv.PCLasso}
\title{Plot the cross-validation curve from a \code{cv.PCLasso} object}
\usage{
\method{plot}{cv.PCLasso}(x, type = c("cve", "rsq", "snr", "all"), norm = NULL, ...)
}
\arguments{
\item{x}{Fitted \code{cv.PCLasso} model.}

\item{type}{What to plot on the vertical axis. "cve" plots the
cross-validation error (deviance); "rsq" plots an estimate of the fraction of
the deviance explained by the model (R-squared); "snr" plots an estimate of
the signal-to-noise ratio; "all" produces all of the above.}

\item{norm}{If TRUE, plot the norm of each group, rather than the individual
coefficients.}

\item{...}{Other graphical parameters to \code{plot}}
}
\value{
No return value, called for plotting of \code{cv.PCLasso} objects.
}
\description{
Plot the cross-validation curve from a \code{cv.PCLasso} object,
along with standard error bars.
}
\details{
Error bars representing approximate +/- 1 SE (68\% confidence
intervals) are plotted along with the estimates at value of lambda. See
\code{plot.cv.grpreg} in the R package \code{grpreg} for details.
}
\examples{
# load data
data(survivalData)
data(PCGroups)

x = survivalData$Exp
y = survivalData$survData

PC.Human <- getPCGroups(Groups = PCGroups, Organism = "Human",
Type = "EntrezID")

# fit model
cv.fit1 <- cv.PCLasso(x, y, group = PC.Human, penalty = "grLasso",
nfolds = 10)

# plot the norm of each group
plot(cv.fit1, norm = TRUE)

# plot the individual coefficients
plot(cv.fit1, norm = FALSE)

# plot the cross-validation error (deviance)
plot(cv.fit1, type = "cve")
}
\seealso{
\code{\link{cv.PCLasso}}
}
