% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PCLasso2}
\alias{plot.PCLasso2}
\title{Plot coefficients from a PCLasso2 object}
\usage{
\method{plot}{PCLasso2}(x, norm = TRUE, ...)
}
\arguments{
\item{x}{Fitted \code{PCLasso2} model.}

\item{norm}{If TRUE, plot the norm of each group, rather than the individual
coefficients.}

\item{...}{Other graphical parameters to \code{plot}.}
}
\value{
No return value, called for plotting of \code{PCLasso2} objects.
}
\description{
Produces a plot of the coefficient paths for a fitted
\code{PCLasso2} object.
}
\examples{
# load data
data(classData)
data(PCGroups)

x = classData$Exp
y = classData$Label

PC.Human <- getPCGroups(Groups = PCGroups, Organism = "Human",
Type = "GeneSymbol")

# fit PCLasso2 model
fit.PCLasso2 <- PCLasso2(x, y, group = PC.Human, penalty = "grLasso")

# plot the norm of each group
plot(fit.PCLasso2, norm = TRUE)

# plot the individual coefficients
plot(fit.PCLasso2, norm = FALSE)
}
\seealso{
\code{\link{PCLasso2}}
}
