% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBlockDiag.R
\name{makeBlockDiag}
\alias{makeBlockDiag}
\title{Generate block-diagonal matrix of size p by p}
\usage{
makeBlockDiag(blocksize = 4, p = 20, min.beta = 0.3, max.beta = 0.9)
}
\arguments{
\item{blocksize}{A positive integer, the dimension of the block matrix. Note, 'blocksize' has to be a factor of 'p'.}

\item{p}{A positive integer, the size of the block-diagonal matrix.}

\item{min.beta}{A positive number, lower limits of the uniform distribution.}

\item{max.beta}{A positive number, upper limits of the uniform distribution.}
}
\value{
A block-diagonal matrix of size 'p' by 'p'.
}
\description{
A utility function generates block-diagonal matrix of size p by p with blocks B1, B2, ..., Bk. Each block matrix is of size blocksize by blocksize. The off-diagonal elements in block matrix are generated from uniform (min.beta, max.beta). The diagonal elements in block matrix are generated from uniform (1, 1.25).
}
\examples{
mat = makeBlockDiag(blocksize=4, p=20)
}
