% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEPlot.R
\name{CEPlot}
\alias{CEPlot}
\title{Cumulative eigenvalue plot}
\usage{
CEPlot(x, nDraw = NULL)
}
\arguments{
\item{x}{x A \code{PCADSC} or \code{angleInfo} object, as produced by \code{\link{PCADSC}} or
\code{\link{doAngle}}, respectively.}

\item{nDraw}{A positive integer. The number of simulated cumulative eigenvalue curves that should
be added to the plot.}
}
\description{
Produce a cumulative eigenvalue (CE) plot from a full or partial \code{PCADSC} object,
as obtained from a call to \code{\link{PCADSC}}. In either case, this \code{PCADSC} object must have a
non-\code{NULL} \code{CEInfo} slot (see examples). The CE plot compares the eigenvalues obtained
from PCA performed separately and jointly on two datasets that consist of different observations
of the same variables.
}
\details{
In the x-coordinates, cumulative differences in eigenvalues are shown,
while the y-coordinates are the cumulative sum of the joint eigenvalues. The plot is annotated
with Kolmogorov-Smirnov and Cramer-von Mises tests evaluated by permutation tests, testing
the null hypothesis of no difference in eigenvalues. The plot also features a number of cumulative
simulated cumulative eigenvalue curves as dashed lines. Moreover, a shaded
area presents pointwise 95 \% confidence bands for the cumulative difference, also obtained using
the permutation test.
}
\examples{
#load iris data
data(iris)

#Define grouping variable, grouping the observations by whether their species is
#Setosa or not
iris$group <- "setosa"
iris$group[iris$Species != "setosa"] <- "non-setosa"
iris$Species <- NULL

\dontrun{
#make a PCADSC object, splitting the data by "group"
irisPCADSC <- PCADSC(iris, "group")

#make a partial PCADSC object from iris and fill out CEInfo in the next call
irisPCADSC2 <- PCADSC(iris, "group", doCE = FALSE)
irisPCADSC2 <- doCE(irisPCADSC2)

#make a CE plot
CEPlot(irisPCADSC)
CEPlot(irisPCADSC2)
}

#Only do CE information and use less resamplings for a faster runtime
irisPCADSC_fast <- PCADSC(iris, "group", doAngle = FALSE, doChroma = FALSE,
  B = 1000)
CEPlot(irisPCADSC_fast)

}
\seealso{
\code{\link{PCADSC}}, \code{\link{doCE}}
}

