.onLoad <- function(lib, pkg)
{
	library.dynam("PBStry", pkg, lib);
}
.onAttach <- function(lib, pkg)
{
	# obtain values necessary for the start-up message
	pkg_info <- utils::sessionInfo( package="PBStry" )$otherPkgs$PBStry
	if( is.character( pkg_info$Packaged ) )
		pkg_date <- strsplit( pkg_info$Packaged, " " )[[1]][1]
	else
		pkg_date  <- date()
	#userguide_path <- system.file( "doc/PBSmapping-UG.pdf", package = "PBSmapping")
	year <- substring(date(),nchar(date())-3,nchar(date()))
	
	packageStartupMessage("
-----------------------------------------------------------
PBS Try ", pkg_info$Version, " -- Copyright (C) 2006-",year," Fisheries and Oceans Canada

PBS Try comes with ABSOLUTELY NO WARRANTY;
but it does provide a handy prototype for R model development.\
It includes the use of C source code, with .C function calls.
\
Usage notes:\
Data sets in a package must be loaded with R's 'data' function.\
Type '?data' for further information.\n


Packaged on ", pkg_date, "
Pacific Biological Station, Nanaimo

All available PBS packages can be found at
https://github.com/pbs-software
");
}
