% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PASWR-package.R
\docType{data}
\name{SBIQ}
\alias{SBIQ}
\title{County IQ}
\format{
A data frame with 40 observations on the following 2 variables:
\describe{ 
\item{County1}{IQ scores for county one}
\item{County2}{IQ scores for county two} 
}
}
\source{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. (2008)
\emph{Probability and Statistics with R}. Chapman & Hall/CRC.
}
\description{
A school psychologist administered the Stanford-Binet intelligence quotient
(IQ) test in two counties. Forty randomly selected, gifted and talented
students were selected from each county. The Stanford-Binet IQ test is said
to follow a normal distribution with a mean of 100 and standard deviation of
16.
}
\examples{

with(data = SBIQ, qqnorm(County1))
with(data = SBIQ, qqline(County1))
# Trellis Approach
qqmath(~County1, data = SBIQ, type=c("p", "r"))

}
\keyword{datasets}
