% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wignerTransform.R
\name{wignerTransform}
\alias{wignerTransform}
\title{Calculate the Wigner-Ville Transform of a Signal}
\usage{
wignerTransform(signal, n = NULL, sr, plot = FALSE)
}
\arguments{
\item{signal}{input signal waveform}

\item{n}{number of frequency bins of the output, if NULL will be the next power of two
from the length of the input signal (recommended)}

\item{sr}{the sample rate of the data}

\item{plot}{logical flag whether or not to plot the result}
}
\value{
a list with three items. \code{tfr}, the real values of the wigner
  transform as a matrix with \code{n} rows and number of columns equal to the next
  power of two from the length of the input signal. \code{f} and \code{t}
  the values of the frequency and time axes.
}
\description{
Calculates the Wigner-Ville transform a signal. By default, the
  signal will be zero-padded to the next power of two before computing the
  transform, and creates an NxN matrix where N is the zero-padded length.
  Note that this matrix can get very large for larger N, consider shortening
  longer signals.
}
\details{
This code mostly follows Pamguard's Java code for computing the
  Wigner-Ville and Hilbert transforms.
}
\examples{
clickWave <- createClickWave(signalLength = .05, clickLength = 1000, clicksPerSecond = 200,
                             frequency = 3e3, sampleRate = 10e3)
wt <- wignerTransform(clickWave@left, n = 1000, sr = 10e3, plot=TRUE)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
