% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate.residuals.R
\name{calculate.residuals}
\alias{calculate.residuals}
\title{Calculate residuals}
\usage{
calculate.residuals(x, distribution)
}
\arguments{
\item{x}{A numeric vector.}

\item{distribution}{A number corresponding to the optimal distribution of \code{x} as returned by, e.g., \code{identify.bic.optimal.data.distribution()}.  One of
\itemize{
\item 1 = normal,
\item 2 = log-normal,
\item 3 = exponential, and
\item 4 = gamma.
}}
}
\value{
A numeric vector of the same length as \code{x}.  Names are not retained.
}
\description{
Calculate residuals between quantiles of the input and quantiles of one of four distributions: normal, log-normal, exponential, or gamma.
}
\examples{
# Generate fake data.
set.seed(1234);
x <- rgamma(
    n = 20,
    shape = 2,
    scale = 2
    );
names(x) <- paste(
    'Sample',
    seq_along(x),
    sep = '.'
    );
calculate.residuals(
    x = x,
    distribution = 4
    );

}
