% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_histogram.R
\name{smooth_histogram}
\alias{smooth_histogram}
\title{Smooth Histogram Data}
\usage{
smooth_histogram(hist_counts, window_size = 5)
}
\arguments{
\item{hist_counts}{A numeric vector of histogram bin counts.}

\item{window_size}{An integer specifying the smoothing window size (default is 5).}
}
\value{
A numeric vector of smoothed histogram counts.
}
\description{
This is an internal function that applies a moving average filter to smooth a histogram.
It is not intended for direct use by package users.
}
\examples{
\donttest{
  raw_counts <- hist(rnorm(1000), plot = FALSE)$counts
  smoothed <- smooth_histogram(raw_counts)
  plot(smoothed, type = "l", col = "blue")
}
}
\keyword{internal}
