% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.calculate_polygon_metrics.R
\name{calculate_polygon_metrics}
\alias{calculate_polygon_metrics}
\title{Calculate Geometric Metrics and Filter Fire Polygons (Batch Mode)}
\arguments{
\item{shapefile_paths}{Character vector. Paths to input shapefiles.}

\item{output_dir}{Optional. Directory to save outputs. Defaults to the input file's folder.}

\item{area_min_ha}{Minimum area in hectares (`area_ha`). Default: 10.}

\item{bbox_h_min}{Minimum height of axis-aligned bounding box (`bbox_hy`). Default: 630.}

\item{mnbbx_wd_min}{Minimum width of rotated bounding box. Default: 800.}

\item{p_w_ratio_min}{Minimum perimeter-to-width ratio. Default: 4.0.}

\item{h_w_ratio_min}{Minimum height-to-width ratio. Default: 0.35.}

\item{output_format}{Output format for saved files: `"shp"` or `"geojson"`. Default: `"shp"`.}

\item{filter_logic}{Logical combination of filters: `"AND"` (default) or `"OR"`.}

\item{dissolve}{Logical. If `TRUE`, dissolve adjacent polygons before computing metrics. Default: TRUE.}

\item{join_attributes}{Logical. If `TRUE`, joins filtered/dissolved polygons back to the original shapefile. Default: TRUE.}

\item{min_input_area_ha}{Minimum area (in hectares) for input polygons used in spatial joins. Default: 10.}

\item{overlay_polygons_path}{Optional. `sf` object or path to shapefile to be used for join instead of the input shapefile. Default: `NULL`.}

\item{columns_to_keep}{Optional. Character vector of variable names to retain from the original shapefile during spatial join. Default: `NULL` (keep all).}
}
\value{
A named list (one element per input file), each containing:
\describe{
  \item{metrics}{Path to shapefile with all polygons and computed metrics.}
  \item{filtered}{Path to shapefile with only polygons passing the filters.}
  \item{joined_metrics}{(If `join_attributes = TRUE`) Path to joined shapefile with original attributes + metrics.}
  \item{joined_filtered}{(If `join_attributes = TRUE`) Path to joined filtered shapefile.}
  \item{polygons_all}{`sf` object of all polygons with computed metrics.}
  \item{polygons_filtered}{`sf` object of polygons that passed the filters.}
}
}
\description{
Calculates geometric descriptors for fire-affected polygons from a list of input shapefiles.
Metrics include area, perimeter, bounding box dimensions, rotated bounding box, and shape ratios.
Optionally applies spatial filters and performs attribute joins to enrich outputs.

For each input shapefile, the function:
- Computes metrics per polygon and saves a new shapefile.
- Applies spatial filters and saves a filtered version.
- Optionally joins metrics back to the original input polygons (if `join_attributes = TRUE`).

If `dissolve = TRUE`, adjacent polygons are merged to reconstruct contiguous burned areas.
A numeric `burned_id` is then assigned to each resulting polygon and used in subsequent joins.

## Metrics computed per polygon:
- `area_ha`: Area in hectares.
- `bbox_wx`: Width of axis-aligned bounding box (x).
- `bbox_hy`: Height of axis-aligned bounding box (y).
- `perim_m`: Perimeter in meters.
- `p_w_ratio`: Perimeter-to-width ratio.
- `h_w_ratio`: Height-to-width ratio.
- `burned_id`: Polygon ID if `dissolve = TRUE`.

## Filter behavior:
All thresholds are optional. If a threshold is `NULL`, the corresponding filter is skipped.
If `filter_logic = "AND"`, all active filters must be satisfied. If `"OR"`, any filter match is sufficient.

## Spatial join (`join_attributes = TRUE`):
- Attributes from the original input shapefile are preserved via intersection-based joins.
- Only input polygons with area ? `min_input_area_ha` are used.
- The join selects, for each input polygon, the intersecting output polygon with the largest shared area.
- Only polygons that intersect filtered outputs are retained in the joined outputs.
- Optionally, you can restrict which variables from the original shapefile to retain using `columns_to_keep`.
}
\note{
Examples require large external raster files (hosted on Zenodo).
Therefore, they are wrapped#' in dontrun{} to avoid errors during R CMD check
and to ensure portability.
}
\examples{
\dontrun{
burned_files <- list.files("path/to/shapefiles", pattern = "\\\\.shp$", full.names = TRUE)

results <- calculate_polygon_metrics(
  shapefile_paths = burned_files,
  output_dir = "outputs/",
  area_min_ha = 10,
  bbox_h_min = 600,
  mnbbx_wd_min = 800,
  p_w_ratio_min = 4.0,
  h_w_ratio_min = 0.25,
  output_format = "geojson",
  filter_logic = "AND",
  dissolve = TRUE,
  join_attributes = TRUE,
  min_input_area_ha = 5,
  columns_to_keep = c("CLC_CODE", "ECOR_REGION")
)
}
}
