\name{MonoisotopicMass}
\alias{MonoisotopicMass}
\title{Calculate the monoisotopic mass or monoisotopic m/z value of an organic molecule.}
\description{Given an elemental formula, the relative atomic masses of the isotopes, and the charge state, determine the monoisotopic mass or monoisotopic m/z value.}
\usage{MonoisotopicMass(formula = list(), isotopes = list(), charge = 0)}
\arguments{  
    \item{formula}{a list describing the uncharged elemental formula.  The allowed elements are C, H, N, O, S, P, Br, Cl, F, Si, and a user defined "x".  See Examples.}
    \item{isotopes}{a list specifing the relative atomic masses of the isotopes.}
    \item{charge}{an integer specifying the number of positive or
      negative charges.  If a charge is specified, the m/z of the
      molecule is calculated by adding or subtracting the specified
      number of protons.  If \code{charge = 0}, the monoisotopic mass is
      returned. See details.}
}
\details{
The elemental formula describes the uncharged molecule; the charge
argument will add or remove hydrogens as needed.  This assumes an
electrospray or MALDI type ionization. In electron impact ionization a
positive charge is generated by loss of an electron, not additon of H+,
therefore to calculate the correct m/z, the charge should be set to zero
as a workaround.

The relative atomic masses of the most abundant
isotopes (carbon-12, hydrogen-1, nitrogen-14, and oxygen-16) are set as
the default values.  For reference, the relative atomic masses of some
common isotopic labels are:

\tabular{ll}{
carbon-13    \tab 13.0033548378\cr
hydrogen-2   \tab 2.0141017780\cr
nitrogen-15  \tab 15.0001088984\cr
oxygen-18    \tab 17.9991604
}

The user defined element \code{x} can be used to define an additional element, such as a metal, or to specify a certain number of isotopically labeled atoms in a molecule.  See Examples.

This function will accept values that do not correspond to known physical reality, such as a fractional number of elements, a fractional charge, or the wrong relative atomic mass value for an isotope.
}
\references{
The relative atomic masses of the isotopes are from the NIST Physical Reference Data Website \url{http://physics.nist.gov/PhysRefData/Compositions/}.  The molar mass of a proton (H+) is from the NIST CODATA Website \url{http://physics.nist.gov/cuu/Constants/index.html}.  
}
\value{The monoisotopic mass of the unchaged molecule or the monoisotopic m/z value of the charged molecule.}
\author{Nathan G. Dodder and Katharine M. Mullen}
\seealso{\code{\link{Digest}}, \code{\link{FragmentPeptide}}, \code{\link{MolecularWeight}}}
\examples{
## monoisotopic m/z of creatinine (C4H7N3O), +1 charge
## unlabeled
MonoisotopicMass(formula = list(C=4, H=7, N=3, O=1), charge = 1)
## with all carbon-13 atoms
MonoisotopicMass(formula = list(C=4, H=7, N=3, O=1), 
                 isotopes = list(C = 13.0033548378),
                 charge = 1) 
## with 2 carbon-12 atoms and 2 carbon-13 atoms
MonoisotopicMass(formula = list(C=2, H=7, N=3, O=1, x=2), 
                 isotopes = list(x = 13.0033548378),
                 charge = 1)

## monoisotopic mass of cyanocobalamin (C63H88CoN14O14P)
MonoisotopicMass(formula = list(C=63, H=88, N=14, O=14, P=1, x=1),
                 isotopes = list(x = 58.9332002))
}
