% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf.MTL.R
\name{conf.MTL}
\alias{conf.MTL}
\title{Confidence interval of mean total lifetime}
\usage{
conf.MTL(obj, state = NULL, nsim = 1000, L = 120)
}
\arguments{
\item{obj}{An object returned by \code{optim.fit}, which contains the transition probabilities
and other information used to simulate mean total lifetime.}

\item{state}{A numeric vector indicating from which state the mean total lifetime is simulated.
Default is NULL, where no mean total life for a specific state is output. If obj is returned by optim.fit with
treatment=NULL, there is no need to set this argument.}

\item{nsim}{The times of simulation for mean total life. The default is 1000.}

\item{L}{The prespecified threshold for blocking the increase of residual lifetime. The default is 120.}
}
\value{
If the input object comes from \code{optim.fit} with \code{treatment=NULL}, a list object with elements:
\item{conf.state.MTL}{A data frame containing states, corresponding mean total lifetime,  standard
 error and 95\% confidence interval. If state=NULL, this element does not exist.}
\item{state.table}{The correspondence of state number and state label.}
If the input object comes from \code{optim.fit} with \code{treatment} is not NULL, a list object with elements:
\item{conf.strategies}{Mean total lifetime for different strategies, along with standard error and 95\% confidence interval}
}
\description{
This function is used to calculate confidence intervals of mean total lifetime using jackknife resampling.
}
\details{
This function systematically leaves out each subject from the original datset and simulates mean total lifetimes
for each \code{n-1}-sized subsample. The jackknife mean and variance are calculated by aggregating \code{n} simulated
mean total lifetimes. For each jackknife dataset, mean total lifetime is simulated using the
algorithm described in sim.MTL.
}
\examples{

\dontrun{
library(OptimalTiming)

##################################
## Example 1: This example shows how to calculate confidence
## intervals for different treatment strategies

## read data
data(SimCml)

## fit multistate model with treatment not equals NULL
fit=optim.fit(data=SimCml,
       transM=matrix(c(0,1,0,0,0,1,0,0,0,1,0,1,1,1,0,0,0,1,1,1,1,
       0,0,0,0,1,1,1,0,0,0,0,0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0),7,byrow=TRUE),
       nstate=7,state_label=c("diagnose","cp1","ap","cp2","bc","sct","death"),
       event_label=c("cp1.s","ap.s","cp2.s","bc.s","sct.s","death.s"),
       treatment=c("sct","sct.s"),absorb=c("death","death.s"),
       cov=c("age"),cov_value=c(0))

## compare different treatment strategies
conf.MTL(obj=fit,nsim=1000,L=120)

##################################
## Example 2: This example shows how to calculate confidence
## intervals for a given state

## read data
data(SimCml)

## delete the information of transplant time
data=SimCml[SimCml$sct.s==0,]
del=which(names(SimCml)\%in\%c("sct","sct.s"))
data=data[,-del]

## fit multistate model with treatment equals NULL
fit=optim.fit(data=data,
        transM=matrix(c(0,1,0,0,0,0,0,0,1,0,1,1,0,0,0,
        1,1,1,0,0,0,0,1,1,0,0,0,0,0,1,0,0,0,0,0,0),6,byrow=TRUE),
        nstate=6,state_label=c("diagnose","cp1","ap","cp2","bc","death"),
        absorb=c("death","death.s"),event_label=c("cp1.s","ap.s","cp2.s","bc.s","death.s"),
        cov=c("age"),cov_value=c(0))

## calculate mean total lifetime and confidence intervals
## for state 1,2,3,4
conf.MTL(obj=fit,state=c(1,2,3,4),nsim=1000,L=120)}



}
\seealso{
\code{\link{optim.fit}}
}
