% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.r
\name{saveAsTxt}
\alias{saveAsTxt}
\title{Save grid in a text file (txt).}
\usage{
saveAsTxt(x, file = NA)
}
\arguments{
\item{x}{\code{repgrid} object.}

\item{file}{Filename to save the grid to. The name should have
the suffix \code{.txt}.}
}
\value{
Invisibly returns the name of the file.
}
\description{
\code{saveAsTxt} will save the grid as a \code{.txt} file
in format used by \pkg{OpenRepGrid}. This file format can also
easily be edited by hand (see \code{\link[=importTxt]{importTxt()}} for a
description).
}
\note{
Structure of a txt file that can be read by \code{\link[=importTxt]{importTxt()}}.

\verb{---------------- .txt file -----------------}

\verb{anything not contained within the tags will be discarded}

\tabular{l}{
\code{ELEMENTS}         \cr
\verb{element 1}        \cr
\verb{element 2}        \cr
\verb{element 3}        \cr
\verb{END ELEMENTS}     \cr
\cr
\code{CONSTRUCTS}                 \cr
\verb{left pole 1 : right pole 1} \cr
\verb{left pole 2 : right pole 2} \cr
\verb{left pole 3 : right pole 3} \cr
\verb{left pole 4 : right pole 4} \cr
\verb{END CONSTRUCTS}             \cr
\cr
\code{RATINGS}        \cr
\verb{1 3 2}          \cr
\verb{4 1 1}          \cr
\verb{1 4 4}          \cr
\verb{3 1 1}          \cr
\verb{END RATINGS}    \cr
\cr
\code{RANGE}          \cr
\verb{1 4}            \cr
\verb{END RANGE}      \cr
}
\verb{---------------- end of file ----------------}
}
\examples{
\dontrun{

x <- randomGrid()
saveAsTxt(x, "random.txt")
}

}
\seealso{
\code{\link[=importTxt]{importTxt()}}
}
