% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpeNoise.R
\name{avr.day.night}
\alias{avr.day.night}
\title{Calculate daily and nightly energetic mean period}
\usage{
avr.day.night(x, variable, period = "day", stat = "n_mean", ...)
}
\arguments{
\item{x}{is a data frame}

\item{variable}{is variable to apply function}

\item{period}{is "day" or "night"}

\item{stat}{is "n_mean" or "e_mean" like mean and energetic mean}

\item{...}{another arguments}
}
\value{
dataframe of energetic mean values by night or daily period
}
\description{
Returns a dataframe with energetic mean
}
\examples{
# Calculate energetic mean in nightly period (22-06)

#data(exampleHourlyData)

avr.day.night(exampleHourlyData, "leq", period = "night",
              stat = "e_mean")[1:5, ]

# Calculate energetic mean in daily period (06-22)
avr.day.night(exampleHourlyData, "leq", period = "day",
              stat = "e_mean")[1:5, ]

# Calculate mean in daily period (06-22)
avr.day.night(exampleHourlyData, "leq", period = "day",
              stat = "n_mean")[1:5, ]

}
\author{
Pasquale Scordino \email{p.scordino@arpa.piemonte.it}

Simone Sperotto \email{s.sperotto@arpa.piemonte.it}
}
