% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpeNoise.R
\name{IntrusiveIndex}
\alias{IntrusiveIndex}
\title{Calculate Intrusive Index (UNI/TS 11844 march 2022)}
\usage{
IntrusiveIndex(dfa, dfr, BW)
}
\arguments{
\item{dfa}{is a dataframe Lfa (enviromental sound levels) 1/3 octave specta data}

\item{dfr}{is a dataframe Lfr (residual sound levels) 1/3 octave specta data}

\item{BW}{a vector of 1/3 octave bandwidth data}
}
\value{
string of intrusive index
}
\description{
Returns a number
}
\examples{
# Calculation of the intrusiveness index

library(OpeNoise)
library(lubridate)

data("dataset_impulsive1")
data("dfBW")

# dataset handling
df_Imp_sec <- dfImpulsiveTrasform(dataset_impulsive1,
                                  statistic = energetic.mean)
df_Imp_sec$date <- ymd_hms(df_Imp_sec$date, tz = "Europe/Rome")

# extraction of frequency bands from the dataset
freqDF <- df_Imp_sec[, grep("LZeq\\\\.", names(df_Imp_sec))]

################################################################################

#                  INTRUSIVENESS INDEX CALCULATION FUNCTION

################################################################################
dfa <- freqDF # Environmental dataset simulation
dfr <- freqDF

# Residual dataset simulation by subtracting 4 from dfa
dfr[c(5,8,12,15), ] <- dfr[c(5,8,12,15), ] - 4

BW <- dfBW$BW # bandwidth

# application of the function
IntrusiveIndex(dfa, dfr, BW)
}
\author{
Pasquale Scordino \email{p.scordino@arpa.piemonte.it}

Simone Sperotto \email{s.sperotto@arpa.piemonte.it}
}
