% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{VinylideneLiverCancer_df}
\alias{VinylideneLiverCancer_df}
\title{Effect of Vinylidene Fluoride on Liver Cancer}
\format{
A data frame with 40 observations and 4 variables:
\describe{
  \item{SDH}{Serum enzyme SDH levels (integer).}
  \item{SGOT}{Serum enzyme SGOT levels (integer).}
  \item{SGPT}{Serum enzyme SGPT levels (integer).}
  \item{dose}{Dose of vinylidene fluoride administered (factor with 4 levels).}
}
}
\source{
Data taken from the goric package.
Silvapulle MJ and Sen PK (2005). *Constrained Statistical Inference: Order, Inequality, and Shape Restrictions*. Wiley.
Litton Bionetics Inc (1984). Report on the effects of vinylidene fluoride on liver enzymes in Fischer-344 rats.
}
\usage{
data(VinylideneLiverCancer_df)
}
\description{
This dataset, VinylideneLiverCancer_df, is a data frame containing data from an experiment to investigate whether vinylidene fluoride induces liver damage. The dataset records the levels of three serum enzymes (SDH, SGOT, SGPT) under four different dosages of vinylidene fluoride. Increased serum enzyme levels are indicative of liver damage.
Real data which are available on page 10 of Silvapulle and Sen (2005) and in a report prepared by Litton Bionetics Inc in 1984. These data were used in an experiment to find out whether vinylidene fluoride gives rise to liver damage.
}
\details{
The dataset name has been kept as 'VinylideneLiverCancer_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
