% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/point_selector.R
\name{get_points_by_ids}
\alias{get_points_by_ids}
\title{Points by ID}
\usage{
get_points_by_ids(id)
}
\arguments{
\item{id}{Integer or list of integers. One or many point ids.}
}
\value{
A data.frame of the requested points, or an empty list if there are no points with those ids.
}
\description{
Queries data points by their ids.
}
\examples{
\dontrun{
points <- get_points_by_ids(c(10000,10001))

# If you are using the point selector function:
query <- PointSelector()

query$buildings <- 101
query$equipment_types <- 'ahu'
query$point_types <- c('Supply Air Temperature','Supply Air Static Pressure')

selection <- select_points(query)

points <- get_points_by_ids(selection$points)
}

}
