### $Id: Muscle.q,v 1.2 1998/04/10 22:52:04 bates Exp $
### Muscle response for different concentrations of CaCl2
### Baumann and Waldvogel (1963), Helvetica Physiologica Acta, 21.
### Cited in Linder, Chakravarti, and Vuagnat (1964).
"Muscle" <-
  structure(list
  (Strip = structure(ordered(c(6, 6, 6, 6, 11, 11, 
     11, 11, 10, 10, 10, 10, 3, 3, 3, 2, 2, 2, 1, 1, 1, 16, 16, 8, 
     8, 5, 5, 13, 13, 9, 9, 9, 20, 20, 12, 12, 7, 7, 14, 14, 18, 18, 
     18, 18, 17, 17, 17, 17, 4, 4, 4, 21, 21, 21, 19, 19, 19, 15, 
     15, 15), levels=1:21), class = c("ordered", "factor"),
     .Label = c("S06", "S05", "S04", "S18", "S09", "S01", "S14",
       "S08", "S11", "S03", "S02", "S13", "S10", "S15", "S21", "S07",
       "S17", "S16", "S20", "S12", "S19")),
   conc = c(2.2, 4.4, 6.6, 8.8, 2.2, 4.4, 6.6, 8.8, 
     0.55, 1.1, 2.2, 4.4, 0.55, 1.1, 2.2, 0.55, 1.1, 2.2, 0.55, 1.1, 
     2.2, 2.2, 4.4, 0.55, 2.2, 1.1, 2.2, 0.55, 2.2, 0.55, 1.1, 2.2, 
     2.2, 4.4, 2.2, 4.4, 1.1, 2.2, 1.1, 2.2, 2.2, 4.4, 6.6, 8.8, 2.2, 
     4.4, 6.6, 8.8, 2.2, 4.4, 6.6, 2.2, 4.4, 6.6, 2.2, 4.4, 6.6, 2.2, 
     4.4, 6.6),
   length = c(15.8, 20.8, 22.6, 23.8, 20.6, 26.8, 28.4, 
     27, 7.2, 15.4, 22.8, 27.4, 2.2, 9, 16.6, 2, 6, 15.2, 5, 9.2, 
     14.2, 28, 32, 5.6, 26, 15.4, 23.2, 11.8, 29, 11, 18.8, 26.2, 
     26, 33.8, 24.2, 28.8, 15, 24, 20.8, 29, 18.2, 25.8, 30, 32.2, 
     21.5, 28.4, 32, 29.6, 15.4, 19, 19.4, 29, 34, 37, 22.2, 29, 32.2, 
     23, 27.4, 30.4)),
row.names = c("3", "4", "5", "6", "9", "10", 
  "11", "12", "13", "14", "15", "16", "19", "20", "21", "25", "26", 
  "27", "31", "32", "33", "39", "40", "43", "45", "50", "51", "55", 
  "57", "61", "62", "63", "69", "70", "75", "76", "80", "81", "86", 
  "87", "93", "94", "95", "96", "99", "100", "101", "102", "105", 
  "106", "107", "111", "112", "113", "117", "118", "119", "123", 
  "124", "125"),
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = length ~ conc | Strip,
labels = list(x = "Concentration of CaCl2",
  y = "Shortening of muscle fibre"),
units = list(x = "(mM)", y = "(mm)"))
