/* adapt.f -- translated by f2c (version 19960717).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"

/* Table of constant values */

static integer c__2 = 2;

/* mm This is the original adapt code with one modification. */
/* mm Instead of calling the external function "FUNCTN", a fixed */
/* mm external routine adphlp is always called, and passed a pointer */
/* mm to the external S function. */
/* mm     Michael Meyer, October 1989. */
/* Subroutine */ int adapt_(ndim, a, b, minpts, maxpts, functn, eps, relerr, 
	lenwrk, wrkstr, finest, ifail)
integer *ndim;
doublereal *a, *b;
integer *minpts, *maxpts;
doublereal *functn, *eps, *relerr;
integer *lenwrk;
doublereal *wrkstr, *finest;
integer *ifail;
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    integer pow_ii();

    /* Local variables */
    static doublereal half;
    extern /* Subroutine */ int bsrl_();
    static doublereal zero;
    static integer j, k;
    static doublereal width[20];
    static integer index1, index2, divflg;
    static doublereal center[20];
    static integer maxcls;
    static doublereal rgnval;
    static integer divaxo;
    static doublereal errmin;
    static integer divaxn;
    static doublereal rgnerr;
    static integer funcls, sbrgns, subrgn, rulcls, sbtmpp, subtmp, rgnstr;
    static doublereal one, two;

/* ***BEGIN PROLOGUE ADAPT */
/*  ADAPTIVE MULTIDIMENSIONAL INTEGRATION SUBROUTINE */
/*           AUTHOR: A. C. GENZ, Washington State University */
/*                    19 March 1984 */
/* **************  PARAMETERS FOR ADAPT  ******************************** 
*/
/* ***** INPUT PARAMETERS */
/*  NDIM    NUMBER OF VARIABLES, MUST EXCEED 1, BUT NOT EXCEED 20 */
/*  A       REAL ARRAY OF LOWER LIMITS, WITH DIMENSION NDIM */
/*  B       REAL ARRAY OF UPPER LIMITS, WITH DIMENSION NDIM */
/*  MINPTS  MINIMUM NUMBER OF FUNCTION EVALUATIONS TO BE ALLOWED. */
/*          ON THE FIRST CALL TO ADAPT MINPTS SHOULD BE SET TO A */
/*          NON NEGATIVE VALUE. (CAUTION... MINPTS IS ALTERED BY ADAPT) */
/*          IT IS POSSIBLE TO CONTINUE A CALCULATION TO GREATER ACCURACY 
*/
/*          BY CALLING ADAPT AGAIN BY DECREASING EPS (DESCRIBED BELOW) */
/*          AND RESETTING MINPTS TO ANY NEGATIVE VALUE. */
/*          MINPTS MUST NOT EXCEED MAXPTS. */
/*  MAXPTS  MAXIMUM NUMBER OF FUNCTION EVALUATIONS TO BE ALLOWED, */
/*          WHICH MUST BE AT LEAST RULCLS, WHERE */
/*          RULCLS =  2**NDIM+2*NDIM**2+6*NDIM+1 */

/*            FOR NDIM =  2   3   4   5   6   7   8   9   10 */
/*            MAXPTS >=  25  45  73 113 173 269 433 729 1285 */
/*         A suggested value for MAXPTS is 100 times the above values. */

/*  FUNCTN  EXTERNALLY DECLARED USER DEFINED FUNCTION TO BE INTEGRATED. */
/*          IT MUST HAVE PARAMETERS (NDIM,Z), WHERE Z IS A REAL ARRAY */
/*          OF DIMENSION NDIM. */
/*  EPS     REQUIRED RELATIVE ACCURACY */
/*  LENWRK  LENGTH OF ARRAY WRKSTR OF WORKING STORAGE, THE ROUTINE */
/*          NEEDS (2*NDIM+3)*(1+MAXPTS/RULCLS)/2 FOR LENWRK IF */
/*          MAXPTS FUNCTION CALLS ARE USED. */
/*          FOR GUIDANCE, IF YOU SET MAXPTS TO 100*RULCLS (SEE TABLE */
/*          ABOVE) THEN ACCEPTABLE VALUES FOR LENWRK ARE */

/*            FOR NDIM = 2    3    4    5    6    7    8     9 */
/*            LENWRK =  357  561  1785 3417 6681 13209 26265 52377 */

/* ***** OUTPUT PARAMETERS */
/*  MINPTS  ACTUAL NUMBER OF FUNCTION EVALUATIONS USED BY ADAPT */
/*  WRKSTR  REAL ARRAY OF WORKING STORAGE OF DIMENSION (LENWRK). */
/*  RELERR  ESTIMATED RELATIVE ACCURACY OF FINEST */
/*  FINEST  ESTIMATED VALUE OF INTEGRAL */
/*  IFAIL   IFAIL=0 FOR NORMAL EXIT, WHEN ESTIMATED RELATIVE ACCURACY */
/*                  RELERR IS LESS THAN EPS WITH MAXPTS OR LESS FUNCTION 
*/
/*                  CALLS MADE. */
/*          IFAIL=1 IF MAXPTS WAS TOO SMALL FOR ADAPT TO OBTAIN THE */
/*                  REQUIRED RELATIVE ACCURACY EPS.  IN THIS CASE ADAPT */
/*                  RETURNS A VALUE OF FINEST WITH ESTIMATED RELATIVE */
/*                  ACCURACY RELERR. */
/*          IFAIL=2 IF LENWRK TOO SMALL FOR MAXPTS FUNCTION CALLS.  IN */
/*                  THIS CASE ADAPT RETURNS A VALUE OF FINEST WITH */
/*                  ESTIMATED ACCURACY RELERR USING THE WORKING STORAGE */
/*                  AVAILABLE, BUT RELERR WILL BE GREATER THAN EPS. */
/*          IFAIL=3 IF NDIM ) 2, NDIM \ 20, MINPTS \ MAXPTS, */
/*                  OR MAXPTS ) RULCLS. */
/* ***********************************************************************
 */
/* ***END PROLOGUE ADAPT */
/* mmmc      EXTERNAL FUNCTN */
/* tslc	Real functn */
/* mmmc */
/* *****  FOR DOUBLE PRECISION CHANGE REAL TO DOUBLE PRECISION IN THE */
/*        NEXT STATEMENT. */
    /* Parameter adjustments */
    --b;
    --a;
    --wrkstr;

    /* Function Body */
    *ifail = 3;
    *relerr = 1.;
    funcls = 0;
    if (*ndim < 2 || *ndim > 20) {
	goto L300;
    }
    if (*minpts > *maxpts) {
	goto L300;
    }

/* *****  INITIALISATION OF SUBROUTINE */

    zero = 0.;
    one = 1.;
    two = 2.;
    half = one / two;
    rgnstr = (*ndim << 1) + 3;
    errmin = zero;
/* Computing 2nd power */
    i__1 = *ndim;
    maxcls = pow_ii(&c__2, ndim) + (i__1 * i__1 << 1) + *ndim * 6 + 1;
    maxcls = min(maxcls,*maxpts);
    divaxo = 0;

/* *****  END SUBROUTINE INITIALISATION */
    if (*minpts < 0) {
	sbrgns = (integer) wrkstr[*lenwrk - 1];
    }
    if (*minpts < 0) {
	goto L280;
    }
    i__1 = *ndim;
    for (j = 1; j <= i__1; ++j) {
	width[j - 1] = (b[j] - a[j]) * half;
/* L30: */
	center[j - 1] = a[j] + width[j - 1];
    }
    *finest = zero;
    wrkstr[*lenwrk] = zero;
    divflg = 1;
    subrgn = rgnstr;
    sbrgns = rgnstr;
L40:
    bsrl_(ndim, center, width, functn, &maxcls, &rulcls, &errmin, &rgnerr, &
	    rgnval, &divaxo, &divaxn);
    *finest += rgnval;
    wrkstr[*lenwrk] += rgnerr;
    funcls += rulcls;

/* *****  PLACE RESULTS OF BASIC RULE INTO PARTIALLY ORDERED LIST */
/* *****  ACCORDING TO SUBREGION ERROR */
    if (divflg == 1) {
	goto L230;
    }

/* *****  WHEN DIVFLG=0 START AT TOP OF LIST AND MOVE DOWN LIST TREE TO */
/*       FIND CORRECT POSITION FOR RESULTS FROM FIRST HALF OF RECENTLY */
/*       DIVIDED SUBREGION */
L200:
    subtmp = subrgn << 1;
    if (subtmp > sbrgns) {
	goto L250;
    }
    if (subtmp == sbrgns) {
	goto L210;
    }
    sbtmpp = subtmp + rgnstr;
    if (wrkstr[subtmp] < wrkstr[sbtmpp]) {
	subtmp = sbtmpp;
    }
L210:
    if (rgnerr >= wrkstr[subtmp]) {
	goto L250;
    }
    i__1 = rgnstr;
    for (k = 1; k <= i__1; ++k) {
	index1 = subrgn - k + 1;
	index2 = subtmp - k + 1;
/* L220: */
	wrkstr[index1] = wrkstr[index2];
    }
    subrgn = subtmp;
    goto L200;

/* *****  WHEN DIVFLG=1 START AT BOTTOM RIGHT BRANCH AND MOVE UP LIST */
/*       TREE TO FIND CORRECT POSITION FOR RESULTS FROM SECOND HALF OF */
/*       RECENTLY DIVIDED SUBREGION */
L230:
    subtmp = subrgn / (rgnstr << 1) * rgnstr;
    if (subtmp < rgnstr) {
	goto L250;
    }
    if (rgnerr <= wrkstr[subtmp]) {
	goto L250;
    }
    i__1 = rgnstr;
    for (k = 1; k <= i__1; ++k) {
	index1 = subrgn - k + 1;
	index2 = subtmp - k + 1;
/* L240: */
	wrkstr[index1] = wrkstr[index2];
    }
    subrgn = subtmp;
    goto L230;
/* *****  STORE RESULTS OF BASIC RULE IN CORRECT POSITION IN LIST */
L250:
    wrkstr[subrgn] = rgnerr;
    wrkstr[subrgn - 1] = rgnval;
    wrkstr[subrgn - 2] = (doublereal) divaxn;
    i__1 = *ndim;
    for (j = 1; j <= i__1; ++j) {
	subtmp = subrgn - (j + 1 << 1);
	wrkstr[subtmp + 1] = center[j - 1];
/* L260: */
	wrkstr[subtmp] = width[j - 1];
    }
    if (divflg == 1) {
	goto L270;
    }
/* *****  WHEN DIVFLG=0 PREPARE FOR SECOND APPLICATION OF BASIC RULE */
    center[divaxo - 1] += two * width[divaxo - 1];
    sbrgns += rgnstr;
    subrgn = sbrgns;
    divflg = 1;
/* *****  LOOP BACK TO APPLY BASIC RULE TO OTHER HALF OF SUBREGION */
    goto L40;

/* *****  END ORDERING AND STORAGE OF BASIC RULE RESULTS */
/* *****  MAKE CHECKS FOR POSSIBLE TERMINATION OF ROUTINE */

/* ******  FOR DOUBLE PRECISION CHANGE ABS TO DABS IN THE NEXT STATEMENT 
*/
L270:
    *relerr = one;
    if (wrkstr[*lenwrk] <= zero) {
	wrkstr[*lenwrk] = zero;
    }
    if (abs(*finest) != zero) {
	*relerr = wrkstr[*lenwrk] / abs(*finest);
    }
    if (*relerr > one) {
	*relerr = one;
    }
    if (sbrgns + rgnstr > *lenwrk - 2) {
	*ifail = 2;
    }
    if (funcls + funcls * rgnstr / sbrgns > *maxpts) {
	*ifail = 1;
    }
    if (*relerr < *eps && funcls >= *minpts) {
	*ifail = 0;
    }
    if (*ifail < 3) {
	goto L300;
    }

/* *****  PREPARE TO USE BASIC RULE ON EACH HALF OF SUBREGION WITH LARGEST
 */
/*       ERROR */
L280:
    divflg = 0;
    subrgn = rgnstr;
    subtmp = (sbrgns << 1) / rgnstr;
    maxcls = *maxpts / subtmp;
    errmin = abs(*finest) * *eps / (real) subtmp;
    wrkstr[*lenwrk] -= wrkstr[subrgn];
    *finest -= wrkstr[subrgn - 1];
    divaxo = (integer) wrkstr[subrgn - 2];
    i__1 = *ndim;
    for (j = 1; j <= i__1; ++j) {
	subtmp = subrgn - (j + 1 << 1);
	center[j - 1] = wrkstr[subtmp + 1];
/* L290: */
	width[j - 1] = wrkstr[subtmp];
    }
    width[divaxo - 1] *= half;
    center[divaxo - 1] -= width[divaxo - 1];

/* *****  LOOP BACK TO APPLY BASIC RULE */

    goto L40;

/* *****  TERMINATION POINT */

L300:
    *minpts = funcls;
    wrkstr[*lenwrk - 1] = (doublereal) sbrgns;
    return 0;
} /* adapt_ */

