/* gee support @(#) cgee.c 4.4 96/10/07 */
#include "cgee.h"
#include <stdio.h>

MATRIX *VC_GEE_diag_as_vec();
MATRIX *VC_GEE_matsqrt();
MATRIX *VC_GEE_mat1over();

void Cgee( x, y, id, n, offset, nobs, p,
	   parmvec, M_parm, 
	   S_beta, S_naivvar, S_robvar,
	   S_phi, S_R, tol, maxsz, S_iter, silent, errorstate , scale_fix )
double *x, *y, *id, *offset, *n;
int *nobs, *p, *M_parm;
int *silent, *parmvec;
int *S_iter;
double *S_beta, *S_naivvar, *S_robvar, *S_phi, *S_R, *tol;
int *maxsz, *errorstate, *scale_fix;
{
/* MAIN DECLS */

MATRIX *xin, *yin, *idin, *offin, *nin;
MATRIX **X, **Y, **OFFSET;
MATRIX **N;
/* MATRIX  *xpx, *xpy, *tmp; */
MATRIX *beta, *betasave;
MATRIX *alpha;
MATRIX *R, *tmpR, *Ri;
MATRIX *One, *mui; /* , *Opmui; */
MATRIX *Ai, *ei , *ete;
MATRIX *S1, *S2, *Di, *this_R, *S5, *S2i;
MATRIX *tempmat1, *tempmat2, *Aop, *Dop, *zi, *DRop;
MATRIX *robvar, *naivvar, *lag_wts, *tmpeep, *scratch, *wt;
char inpp;
double phi, dni;
int iter, ini, i2, j2, k;
int alpha_VC_GEE_bandwidth;
int *onep, one, nclust, i; /* , j; */
double alpha_scalar;
int maxni, ni, *maxnip;
int link, var_mean_rel, corstruct;
int *maxiter;

maxiter = (int* ) malloc(sizeof(int));
*errorstate = UNKNOWN_FAILURE ;
errorbranch( Bail ); 

if (!(*silent)) printf("@(#) cgee.c 94/03/26 Cgee: GEE C source version chanlib 3.2.1.1 \n");
/* /scsi2/stvjc/PROGRAMMING/CHANLIB/CGEE/gee/SCCS/s.cgee.c */

/* Initialize data */

alpha = NULL;
alpha_scalar = 0;
iter = 0;
one = 1.;

*maxiter = *S_iter;
link = (*parmvec) -1;
var_mean_rel = (*(parmvec+1)) -1;
corstruct = (*(parmvec+2)) -1;

alpha_VC_GEE_bandwidth = *M_parm + 1;

onep = &one;

from_S( y , nobs , onep , yin )
from_S( x , nobs , p , xin )
from_S( id , nobs , onep , idin )
from_S( offset, nobs, onep, offin )
from_S( n, nobs, onep, nin )
from_S( S_beta, p, onep, beta );

nclust = VC_GEE_nchanges( idin );

#define set_matrix_array( arrname, nel ) \
   if (!( arrname = (MATRIX **)malloc((unsigned)(nel * sizeof(MATRIX *))))) \
     { fprintf(stderr, \
            "set_matrix_array (mac): out of memory, requesting %d elements\n",nel); \
     exit(1); \
     }

set_matrix_array( X, nclust )
set_matrix_array( Y, nclust )
set_matrix_array( OFFSET, nclust )
set_matrix_array( N, nclust )

VC_GEE_split( xin , idin , X );
VC_GEE_split( yin , idin, Y );
VC_GEE_split( offin , idin , OFFSET );
VC_GEE_split( nin , idin , N );

VC_GEE_destroy_matrix( xin );
VC_GEE_destroy_matrix( yin );
VC_GEE_destroy_matrix( idin );
VC_GEE_destroy_matrix( offin );
VC_GEE_destroy_matrix( nin );

maxni = Y[0]->nrows;
for ( i = 1 ; i < nclust ; i++ )
	{
	ni = Y[i]->nrows;
	if ( ni > maxni ) maxni = ni;
	}
*maxsz = maxni;
maxnip = &maxni;

/* xpx = VC_GEE_create_matrix( *p, *p , EPHEMERAL );
xpy = VC_GEE_create_matrix( *p, one , EPHEMERAL ); */

if ( corstruct == (int) fixed ) 
	{
	from_S( S_R, maxnip, maxnip , R );
	}

if (!(*silent))
	{
	printf("Cgee will use: ");
	switch( link )
		{
		case VC_GEE_identity:
			printf("VC_GEE_identity link, ");
			break;
		case logarithm:
			printf("log link, ");
			break;
		case logit:
			printf("logit link, ");
			break;
		case reciprocal:
			printf("recip link, ");
			break;
		case probit:
			printf("probit link, ");
			break;
                case cloglog:
                        printf("cloglog link, ");
                        break;
		default:
			printf("unknown link.\n");
			exit( UNKNOWN_LINK );
			break;
		}
	switch( var_mean_rel )
		{
		case Gaussian:
			printf("Gaussian var, ");
			break;
		case Poisson:
			printf("Poisson var, ");
			break;
		case Binomial:
			printf("Binomial var, ");
			break;
		case Gamma:
			printf("Gamma var, ");
			break;
		default:
			fprintf( stderr,
			"Cgee: unknown var_mean_rel. Dies.\n");
			exit( UNKNOWN_VAR_MEAN_REL );
			break;
		}
	switch ( corstruct )
		{
		case independence:
			printf("indep corstr . ");
			break;
		case exchangeable:
			printf("exch corstr . ");
			break;
		case stat_M_dep:
			printf("stat corstr . ");
			break;
		case AR_M:
			printf("AR-M corstr . ");
			break;
		case non_stat_M_dep:
			printf("non-statM corstr . ");
			break;
		case unstructured:
			printf("unstr corstr . ");
			break;
		case fixed:
			printf("fixed corstr . ");
			break;
		default:
			printf("unknown corstr. ");
			exit(1);
			break;
		}
	printf("\n");
	}


scratch = VC_GEE_create_matrix( maxni, maxni, EPHEMERAL );

do
	{
	betasave = VC_GEE_matcopy(beta);
	phi = 0.;
	tmpR = VC_GEE_create_matrix( maxni, maxni, EPHEMERAL );


	switch ( corstruct )
		{
		case independence:
			break;
		case exchangeable:
			alpha_scalar = 0.;
			break;
		case stat_M_dep:
		case AR_M:
			alpha = VC_GEE_create_matrix( 1 , alpha_VC_GEE_bandwidth , EPHEMERAL);
			break;
		case non_stat_M_dep:
		case unstructured:
			alpha = VC_GEE_create_matrix( maxni, maxni, EPHEMERAL );
			break;
		case fixed:
			break;
		default:
			break;
		}

	make_permanent( beta );
	for ( i = 0 ; i < nclust ; i++ ) 
		{
		ni = Y[i]->nrows;
		dni = (double)ni;
		One = VC_GEE_col_1s( ni );
		make_permanent( One );
		tempmat1 = VC_GEE_matadd( VC_GEE_matmult( X[i] , beta ), OFFSET[i] );

		switch ( link )
			{
			double maxfitted;
			case VC_GEE_identity:
				mui = VC_GEE_matcopy( tempmat1 );
				break;
			case logarithm:
				mui = VC_GEE_matexp( tempmat1 );
				break;
			case logit:
				tempmat1 = VC_GEE_matexp( tempmat1 );
				make_permanent( tempmat1 );
				tempmat2 = VC_GEE_matadd( One, tempmat1);
				mui = VC_GEE_pxq_divby_px1( VC_GEE_px1_times_pxq( N[i],
					tempmat1), tempmat2);
				make_permanent(mui);
				maxfitted = VC_GEE_matmax(VC_GEE_pxq_divby_px1(mui,N[i]));
				if ( (maxfitted >= .9999 ) && var_mean_rel == (int) Binomial ) 
					{
					fprintf(stderr,"Cgee: error: logistic model for probability has fitted value very close to 1.\n");
					fprintf(stderr,"Cgee: estimates diverging; iteration terminated.\n");
					fprintf(stderr,"Cgee: returning to S\n");
					return;
					}  
				VC_GEE_destroy_matrix(tempmat1);
				break;
			case reciprocal:
				mui = VC_GEE_pxq_divby_px1(
					One, tempmat1 );
				break;
/* probit case added by pj catalano*/  /* OK */
                        case probit:
                                tempmat1 = VC_GEE_matncdf(tempmat1);
                                mui = VC_GEE_px1_times_pxq( N[i], tempmat1);
                                make_permanent(mui);
                                maxfitted = VC_GEE_matmax(VC_GEE_pxq_divby_px1(mui, N[i]));
                                if ( (maxfitted >= .9999 ) && var_mean_rel == Binomial)
                                        {
		fprintf(stderr,"Cgee: estimates diverging; iteration terminated.\n");
                                        fprintf(stderr,"Cgee: returning to S\n");
                                        *errorstate = LOGISTIC_DIVERGENCE;
                                        return;
                                        }
                                 break;

 /* cloglog case added by jh maindonald */
                        case cloglog:
                                tempmat1=VC_GEE_matanticlog(tempmat1);
                                mui=VC_GEE_px1_times_pxq(N[i], tempmat1);
                                make_permanent(mui);
                                maxfitted = VC_GEE_matmax(VC_GEE_pxq_divby_px1(mui, N[i]));
                                if ( (maxfitted >= .999999 ) && var_mean_rel == (int) Binomial )
                                        {
                                        fprintf(stderr,"Cgee: error: cloglog model for probability has fit ted value very close to 1.\n");
                                        fprintf(stderr,"Cgee: estimates diverging; iteration terminated.\n ");
                                        fprintf(stderr,"Cgee: returning to S\n");
                                        return;
                                        }
                                break;

			default:
				fprintf( stderr,
				"Cgee: unknown link. Dies.\n");
				exit( UNKNOWN_LINK );
				break;
			}
		make_permanent( mui );
		ei = VC_GEE_matsub( Y[i], mui );
		
		switch( var_mean_rel )
			{
			case Gaussian:
			/*	Ai = VC_GEE_ident(ni); */
				break;
			case Poisson:
				Ai = VC_GEE_form_diag( mui );
				break;
			case Binomial:
				Ai = VC_GEE_form_diag( VC_GEE_px1_times_pxq(
				mui, VC_GEE_matsub( One, VC_GEE_pxq_divby_px1(mui,N[i]))));
				break;
			case Gamma:
				Ai = VC_GEE_form_diag( VC_GEE_px1_times_pxq(
				mui, mui ));
				break;
			default:
				fprintf( stderr,
				"Cgee: unknown var_mean_rel. Dies.\n");
				exit( UNKNOWN_VAR_MEAN_REL );
				break;
			}
		VC_GEE_destroy_matrix(mui);

		if (var_mean_rel != Gaussian )
		ei = VC_GEE_px1_times_pxq( VC_GEE_mat1over(VC_GEE_matsqrt(VC_GEE_diag_as_vec(Ai))), ei );

		make_permanent( ei );

		ete = VC_GEE_matmult( VC_GEE_transp(ei), ei );

		phi += MEL(ete,0,0)/dni;
		if ( corstruct == (int) stat_M_dep || corstruct == (int) AR_M )
			{
			if ( dni < (double)alpha_VC_GEE_bandwidth )
				{
fprintf(stderr,"cgee: M-dependence, M=%d, but clustsize=%d\n",*M_parm,(int)dni);
fprintf(stderr,"cgee: M-dependence, fatal error for this model.\n");
exit(M_DEP_SIZE_LT_M);
				}
			
			lag_wts = VC_GEE_create_matrix( 1, alpha_VC_GEE_bandwidth, PERMANENT );
			MEL( lag_wts, 0, 0 ) = (double)1.;

			for ( ini = 1 ; ini < alpha_VC_GEE_bandwidth ; ini++ )
				{
				MEL(lag_wts, 0, ini) = dni/(dni - (double)ini);
				}
			}
		
		switch ( corstruct )
			{
			case independence:
				break;
			case exchangeable:
				if ( ni > 1 ) alpha_scalar +=
1./(dni*(dni-1.)) * (VC_GEE_elsum( VC_GEE_matmult( ei, VC_GEE_transp(ei) ) ) - MEL(ete,0,0));
				break;
			case stat_M_dep:
			case AR_M:

alpha = VC_GEE_matadd( alpha, VC_GEE_transp( VC_GEE_px1_times_pxq ( VC_GEE_transp(lag_wts), VC_GEE_transp(VC_GEE_covlag( ei , alpha_VC_GEE_bandwidth , 0 ) ) ) ) );
				break;
			case non_stat_M_dep:
			case unstructured:
				tmpeep = VC_GEE_matmult( ei, VC_GEE_transp(ei) );
				VC_GEE_plug( tmpeep , scratch , 0, 0);
				make_permanent(scratch);
				alpha = VC_GEE_matadd( alpha, scratch );
				scratch = VC_GEE_matsub( scratch, scratch );
				make_ephemeral(scratch);
				break;
			case fixed:
				break;
			default:
			fprintf(stderr,"corstruct not implemented.\n");
				exit(1);
				break;
			}
		VC_GEE_destroy_matrix(ei);
		VC_GEE_destroy_matrix(One);
	      }

	if  (alpha != NULL ) alpha = VC_GEE_scalar_times_matrix( 1./phi , alpha );

	alpha_scalar /= phi;

	phi /= (double)nclust;

	switch( corstruct )
		{
		case independence:  /* this is ridiculous */
			R = VC_GEE_ident( maxni );
			break;
		case exchangeable:
R = VC_GEE_matadd( VC_GEE_scalar_times_matrix( alpha_scalar , VC_GEE_matmult( VC_GEE_col_1s(maxni), VC_GEE_transp( VC_GEE_col_1s(maxni) ))), VC_GEE_scalar_times_matrix( (double)1.-alpha_scalar,VC_GEE_ident(maxni)));
			break;
		case stat_M_dep:
			tmpR = VC_GEE_create_matrix( 1, maxni, EPHEMERAL );
			VC_GEE_plug( alpha, tmpR, 0, 0 );
			MEL( tmpR, 0, 0 ) = (double)1.;
			R = VC_GEE_toeplitz( tmpR );
			break;
		case AR_M:
			tmpR = VC_GEE_create_matrix( 1, maxni, EPHEMERAL );
			MEL( alpha, 0, 0) = (double)1.;
			make_permanent(alpha);
			VC_GEE_plug( alpha, tmpR, 0,0);
			tempmat1 = VC_GEE_extract_cols( alpha, 0, alpha_VC_GEE_bandwidth-2 );
			wt = VC_GEE_toeplitz( tempmat1 );
			tempmat1 = VC_GEE_extract_cols( alpha, 1, alpha_VC_GEE_bandwidth-1 );
			alpha = VC_GEE_matmult( tempmat1, VC_GEE_luinv( wt ) );
			for ( i2 = alpha_VC_GEE_bandwidth ; i2 < maxni ; i2++ )
				{
				for ( j2 = 0 ; j2 < alpha_VC_GEE_bandwidth-1 ; j2++ )
					{
					MEL( tmpR, 0, i2 ) += MEL(alpha,0,j2) *
					MEL(tmpR,0,(i2-j2)-1);
					}
				}
			R = VC_GEE_toeplitz( tmpR );
			VC_GEE_destroy_matrix(alpha);
			break;
		case non_stat_M_dep:
			R = VC_GEE_band( alpha, alpha_VC_GEE_bandwidth );
			for ( k = 0 ; k < R->ncols ; k++ )
				{
				MEL( R, k, k) = (double)1.;
				}
			break;
		case unstructured:
			R = VC_GEE_matcopy( alpha );
			for ( k = 0 ; k < R->ncols ; k++ )
				{
				MEL( R, k, k) = (double)1.;
				}
			break;
		case fixed:
			break;
		default:
			fprintf(stderr,"corstruct not implemented.\n");
			exit(1);
			break;
		}
	make_permanent(R);

	S1 = VC_GEE_create_matrix( *p, 1, EPHEMERAL);
	S2 = VC_GEE_create_matrix( *p, *p, EPHEMERAL);

	for ( i = 0 ; i < nclust ; i++ )
		{
		ni = Y[i]->nrows;
		dni = (double)ni;
		One = VC_GEE_col_1s(ni);
		make_permanent( One );

		tempmat1 = VC_GEE_matadd( VC_GEE_matmult( X[i], beta ), OFFSET[i] );
		switch ( link )
			{
			case VC_GEE_identity:
				Di = VC_GEE_matcopy(X[i]);
				mui = VC_GEE_matcopy( tempmat1 );
				break;
			case logarithm:
				tempmat1 = VC_GEE_matexp( tempmat1 );
				mui = VC_GEE_matcopy( tempmat1 );
				Di = VC_GEE_px1_times_pxq( tempmat1, X[i]);
				break;
			case logit:
				tempmat1 = VC_GEE_matexp( tempmat1 );
				make_permanent( tempmat1 );
				tempmat2 = VC_GEE_matadd( One, tempmat1);
				tempmat2 = VC_GEE_pxq_divby_px1(
					VC_GEE_px1_times_pxq( N[i], tempmat1), tempmat2 );
				make_permanent( tempmat2 );
				VC_GEE_destroy_matrix( tempmat1 );
				tempmat1 = VC_GEE_matsub( One, VC_GEE_pxq_divby_px1(tempmat2,N[i]));
				tempmat1 = VC_GEE_px1_times_pxq( tempmat1, 
					tempmat2 );
				Di = VC_GEE_px1_times_pxq( tempmat1, X[i]);
				mui = VC_GEE_matcopy( tempmat2 );
				VC_GEE_destroy_matrix( tempmat2 );
				break;
			case reciprocal:
				tempmat1 = VC_GEE_pxq_divby_px1(
					One, tempmat1 );
				mui = VC_GEE_matcopy(tempmat1);
				tempmat2 = VC_GEE_matcopy(tempmat1);
				tempmat1 = VC_GEE_px1_times_pxq( tempmat1, tempmat2 );
				tempmat1 = VC_GEE_px1_times_pxq(
				tempmat1, X[i] );
				Di = VC_GEE_scalar_times_matrix( -1., tempmat1 );
				break;
 /* probit case added by pj catalano */
                        case probit:
                                tempmat2 = VC_GEE_matcopy(tempmat1);
                                tempmat2 = VC_GEE_matncdf(tempmat2);
                                mui = VC_GEE_px1_times_pxq( N[i],tempmat2 );
                                tempmat1 = VC_GEE_matnpdf(tempmat1);
                                tempmat2 = VC_GEE_px1_times_pxq( N[i],tempmat1 );
                                Di = VC_GEE_px1_times_pxq( tempmat2, X[i] );
                                break;
/* cloglog case added by jh maindonald */
                        case cloglog:
                                tempmat2=VC_GEE_matcopy(tempmat1);
                                tempmat1=VC_GEE_matanticlog(tempmat1);
                                make_permanent(tempmat1);
                                mui=VC_GEE_px1_times_pxq(N[i], tempmat1);
                                tempmat2=VC_GEE_matexp(tempmat2);
                                tempmat2=VC_GEE_px1_times_pxq(N[i],tempmat2);
                                tempmat1=VC_GEE_px1_times_pxq(tempmat2,VC_GEE_matsub(One,tempmat1));
                                Di=VC_GEE_px1_times_pxq(tempmat1,X[i]);
                                VC_GEE_destroy_matrix(tempmat1);
                                break;

			default:
				fprintf( stderr,
				"Cgee: unknown link. Dies.\n");
				exit( UNKNOWN_LINK );
				break;
			}
		make_permanent( mui );
		make_permanent( Di );

		zi = VC_GEE_matadd( VC_GEE_matmult( Di, beta), VC_GEE_matsub( Y[i],
		mui ) );

		switch( var_mean_rel )
			{
			case Gaussian:
				/* Ai = VC_GEE_ident(ni); */
				break;
			case Poisson:
				Ai = VC_GEE_form_diag( mui );
				break;
			case Binomial:
				Ai = VC_GEE_form_diag( VC_GEE_px1_times_pxq(
				mui, VC_GEE_matsub( One, VC_GEE_pxq_divby_px1(mui,N[i]))));
				break;
			case Gamma:
				Ai = VC_GEE_form_diag( VC_GEE_px1_times_pxq(
				mui, mui ));
				break;
			default:
				fprintf( stderr,
				"Cgee: unknown var_mean_rel. Dies.\n");
				exit( UNKNOWN_VAR_MEAN_REL );
				break;
			}
		VC_GEE_destroy_matrix(mui);

		if ( var_mean_rel != Gaussian )  /* else Ai is VC_GEE_identity */
		Aop = VC_GEE_mat1over( VC_GEE_matsqrt( VC_GEE_diag_as_vec( Ai )) );
		if ( var_mean_rel != Gaussian )  /* else Ai is VC_GEE_identity */
		make_permanent( Aop );


		make_ephemeral( Di );
		if ( var_mean_rel != Gaussian )
		  Di = VC_GEE_px1_times_pxq( Aop, Di );
		make_permanent( Di );
		if ( var_mean_rel != Gaussian )
		  zi = VC_GEE_px1_times_pxq( Aop, zi );

		if ( corstruct != independence )
		{
		this_R = VC_GEE_corner( R, ni, ni );
        	/* printf("cluster %d g\n",i); */

		/* printf("VC_GEE_start inver\n");
		printf("D: %d x %d, R: %d x %d\n",Di->nrows,
			   Di->ncols, this_R->nrows, this_R->ncols); */
		Ri = VC_GEE_luinv(this_R);
		/* printf("D: %d x %d, Ri: %d x %d\n",Di->nrows,
			   Di->ncols, Ri->nrows, Ri->ncols); */
		Dop = VC_GEE_matmult( VC_GEE_transp(Di), Ri );
		/* printf("end inver\n"); */
		}
		else Dop = VC_GEE_transp(Di);

		make_permanent( Dop );

		S1 = VC_GEE_matadd( S1, VC_GEE_matmult( Dop, zi ) );
		S2 = VC_GEE_matadd( S2, VC_GEE_matmult( Dop, Di ) );

		VC_GEE_destroy_matrix(Dop);
		if ( var_mean_rel != Gaussian )
		VC_GEE_destroy_matrix(Aop);
		VC_GEE_destroy_matrix(Di);
		VC_GEE_destroy_matrix(One);

		}

	VC_GEE_destroy_matrix(beta);
	beta = VC_GEE_matmult( VC_GEE_luinv( S2 ), S1 );
	make_permanent(beta);

	if (!(*silent)) printf("current parameter estimates:\n");

	if (!(*silent)) VC_GEE_matdump(beta);

	if (!(*silent)) printf( "completed iteration %d\n",iter);
	iter++;


		
	} while(( VC_GEE_matmax( VC_GEE_matabs( VC_GEE_matsub( VC_GEE_pxq_divby_px1( betasave, beta ), VC_GEE_col_1s(*p)))) > *tol) && (iter < *maxiter ));

if ( iter >= *maxiter ) 
	{
	fprintf(stderr,"Maximum number of iterations consumed.\n");
	fprintf(stderr,"Convergence not achieved; results suspect.\n");
	*errorstate = MAXITER_EXCEEDED ;
	}

S2 = VC_GEE_create_matrix( *p, *p, EPHEMERAL);
S5 = VC_GEE_create_matrix( *p, *p, EPHEMERAL);
phi = 0.;

for ( i = 0 ; i < nclust ; i++ )
	{
	ni = Y[i]->nrows;
	dni = (double)ni;
	One = VC_GEE_col_1s(ni);
	make_permanent( One );

	tempmat1 = VC_GEE_matadd( VC_GEE_matmult( X[i], beta ), OFFSET[i] );
	switch ( link )
		{
		case VC_GEE_identity:
			Di = VC_GEE_matcopy(X[i]);
			mui = VC_GEE_matcopy( tempmat1 );
			break;
		case logarithm:
			tempmat1 = VC_GEE_matexp( tempmat1 );
			mui = VC_GEE_matcopy( tempmat1 );
			Di = VC_GEE_px1_times_pxq( tempmat1, X[i]);
			break;
		case logit:
				tempmat1 = VC_GEE_matexp( tempmat1 );
				make_permanent( tempmat1 );
				tempmat2 = VC_GEE_matadd( One, tempmat1);
				tempmat2 = VC_GEE_pxq_divby_px1(
					VC_GEE_px1_times_pxq( N[i], tempmat1), tempmat2 );
				make_permanent( tempmat2 );
				VC_GEE_destroy_matrix( tempmat1 );
				tempmat1 = VC_GEE_matsub( One, VC_GEE_pxq_divby_px1(tempmat2,N[i]));
				tempmat1 = VC_GEE_px1_times_pxq( tempmat1, 
					tempmat2 );
				Di = VC_GEE_px1_times_pxq( tempmat1, X[i]);
				mui = VC_GEE_matcopy( tempmat2 );
				VC_GEE_destroy_matrix( tempmat2 );
				break;
		case reciprocal:
			tempmat1 = VC_GEE_pxq_divby_px1(
				One, tempmat1 );
			mui = VC_GEE_matcopy(tempmat1);
			tempmat2 = VC_GEE_matcopy(tempmat1);
			tempmat1 = VC_GEE_px1_times_pxq( tempmat1, tempmat2 );
			tempmat1 = VC_GEE_px1_times_pxq(
			tempmat1, X[i] );
			Di = VC_GEE_scalar_times_matrix( -1., tempmat1 );
			break;
 /* probit case added by pj catalano*/
                case probit:
                        tempmat2 = VC_GEE_matcopy(tempmat1);
                        tempmat2 = VC_GEE_matncdf(tempmat2);
                        mui = VC_GEE_px1_times_pxq( N[i],tempmat2 );
                        tempmat1 = VC_GEE_matnpdf(tempmat1);
                        tempmat2 = VC_GEE_px1_times_pxq( N[i],tempmat1 );
                        Di = VC_GEE_px1_times_pxq( tempmat2, X[i] );
                        break;
/* maind */
                case cloglog:
                                tempmat2=VC_GEE_matcopy(tempmat1);
                                tempmat1=VC_GEE_matanticlog(tempmat1);
                                make_permanent(tempmat1);
                                mui=VC_GEE_px1_times_pxq(N[i], tempmat1);
                                tempmat2=VC_GEE_matexp(tempmat2);
                                tempmat2=VC_GEE_px1_times_pxq(N[i],tempmat2);
                                tempmat1=VC_GEE_px1_times_pxq(tempmat2,VC_GEE_matsub(One,tempmat1));
                                Di=VC_GEE_px1_times_pxq(tempmat1,X[i]);
                                VC_GEE_destroy_matrix(tempmat1);
                                break;

		default:
			fprintf( stderr,
			"Cgee: unknown link. Dies.\n");
			exit( UNKNOWN_LINK );
			break;
		}
	make_permanent( mui );

	ei = VC_GEE_matsub( Y[i] ,mui );
	switch( var_mean_rel )
		{
		case Gaussian:
			/* Ai = VC_GEE_ident(ni); */
			break;
		case Poisson:
			Ai = VC_GEE_form_diag( mui );
			break;
		case Binomial:
			Ai = VC_GEE_form_diag( VC_GEE_px1_times_pxq(
			mui, VC_GEE_matsub( One, VC_GEE_pxq_divby_px1(mui,N[i]))));
			break;
		case Gamma:
			Ai = VC_GEE_form_diag( VC_GEE_px1_times_pxq(
			mui, mui ));
			break;
		default:
			fprintf( stderr,
			"Cgee: unknown var_mean_rel. Dies.\n");
			exit( UNKNOWN_VAR_MEAN_REL );
			break;
		}
	VC_GEE_destroy_matrix(mui);
	VC_GEE_destroy_matrix(One);

	if ( var_mean_rel != Gaussian )
	  {
	    Aop = VC_GEE_mat1over( VC_GEE_matsqrt( VC_GEE_diag_as_vec( Ai ) ) );
	    make_permanent( Aop );
	    Di = VC_GEE_px1_times_pxq( Aop, Di );
	  }
	make_permanent( Di );

	if ( var_mean_rel != Gaussian )
	  ei = VC_GEE_px1_times_pxq( Aop, ei );
	make_permanent( ei );

	ete = VC_GEE_matmult( VC_GEE_transp(ei), ei);
	phi += MEL(ete,0,0) / dni;

	if (corstruct != independence)
	DRop = VC_GEE_matmult( VC_GEE_transp(Di), VC_GEE_luinv( VC_GEE_corner( R, ni, ni ) ) );
	else
	DRop = VC_GEE_transp(Di);

	make_permanent( DRop );

	S2 = VC_GEE_matadd( S2, VC_GEE_matmult( DRop , Di ) );
/* printf("VC_GEE_start S5\n"); */
	S5 = VC_GEE_matadd( S5, VC_GEE_matmult( VC_GEE_matmult( DRop , ei ),
			VC_GEE_matmult(VC_GEE_transp(ei), VC_GEE_transp(DRop))));
	/* printf("end S5\n"); */

	if ( var_mean_rel != Gaussian )
	VC_GEE_destroy_matrix( Aop );
	VC_GEE_destroy_matrix( Di );
	VC_GEE_destroy_matrix( ei );
	VC_GEE_destroy_matrix( DRop );
	}

phi /= (double)nclust;

S2i = VC_GEE_luinv(S2);
make_permanent( S2i );
if ( *scale_fix ) phi = *S_phi;
if ( *scale_fix && var_mean_rel == Gaussian )
	fprintf(stderr,"Scale parameter fixed at %f with Gaussian variance function.\n",
			      *S_phi);
naivvar = VC_GEE_scalar_times_matrix( phi, S2i );
robvar = VC_GEE_matmult( VC_GEE_matmult ( S2i, S5 ), S2i );

to_S( beta, S_beta )
to_S( naivvar, S_naivvar )
to_S( robvar, S_robvar )
to_S( R, S_R )

*S_phi = phi;
*S_iter = iter;

VC_GEE_destroy_matrix( beta );
VC_GEE_destroy_matrix( naivvar );
VC_GEE_destroy_matrix( robvar );
VC_GEE_destroy_matrix( R );

for ( i = 0 ; i < nclust ; i++ )
	{
	VC_GEE_destroy_matrix( X[i] );
	VC_GEE_destroy_matrix( Y[i] );
	VC_GEE_destroy_matrix( N[i] );
	VC_GEE_destroy_matrix( OFFSET[i] );
	}

if ( iter < *maxiter ) *errorstate = NO_ERROR; 
Bail:
;
}
