% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen.R
\docType{data}
\name{timeuse_data}
\alias{timeuse_data}
\title{TimeUse+ Data}
\format{
Data frame with numeric and factor columns
\describe{
\item{id}{Respondent ID}
\item{start_tracking}{Indicator for the months when the participant started tracking}
\item{weekly_km}{Weekly distance covered (in km) across all modes}
\item{log_weekly_km}{Log of \code{weekly_km}}
\item{wfh_days}{Based on tracked work episodes. Average full working days spent in home office during a typical week.}
\item{wfh}{Derived from \code{wfh_days}: NTW=Non-TWer, NUTW=Non-usual TWer (< 3 days/week), UTW=Usual TWer(3+ days/week)}
\item{commute_km}{Map matched commute distance in km}
\item{log_commute_km}{Log of \code{commute_km}}
\item{age}{Age}
\item{car_access}{Has access to a household car}
\item{dogs}{Household owns dogs}
\item{driverlicense}{Owns driver's license for cars}
\item{educ_higher}{Higher education (e.g., university)}
\item{fixed_workplace}{Main work location does not change regularly}
\item{grocery_shopper}{Does usually do the grocery shopping}
\item{hh_income}{Gross household income per month (CHF)}
\item{hh_size}{Total household size}
\item{isco_clerical}{International standard classification of Occupations (ISCO-08): Clerical support workers}
\item{isco_craft}{International standard classification of Occupations (ISCO-08): Craft related trade workers}
\item{isco_elementary}{International standard classification of Occupations (ISCO-08): Elementary occupations}
\item{isco_managers}{International standard classification of Occupations (ISCO-08): Managers}
\item{isco_plant}{International standard classification of Occupations (ISCO-08): Plant and machine operators, and assemblers}
\item{isco_professionals}{International standard classification of Occupations (ISCO-08): Professionals}
\item{isco_service}{International standard classification of Occupations (ISCO-08): Service and sales workers}
\item{isco_agri}{International standard classification of Occupations (ISCO-08): Skilled agricultural, forestry and fishery workers}
\item{isco_tech}{International standard classification of Occupations (ISCO-08): Technicians and associate professionals}
\item{married}{Married}
\item{n_children}{Number of household members below the age of 18}
\item{freq_onl_order}{Orders products online more than once a month}
\item{parking_home}{Has at least one reserved parking space at home}
\item{parking_work}{Has at least one reserved parking space at work location}
\item{permanent_employment}{Employment contract type: permenent (unlimited employed)}
\item{rents_home}{Residential situation: Rents home}
\item{res_loc}{Residential location}
\item{sex_male}{Gender}
\item{shift_work}{Whether participant works in shifts}
\item{swiss}{Swiss citizen}
\item{vacation}{Participant took time off of work during study}
\item{workload}{Workload (\% of full-time employment which is 41.7 h/week)}
\item{young_kids}{Whether children aged 12 or younger live in the household}
}
}
\usage{
timeuse_data
}
\description{
TimeUse+ \insertCite{Winkler+Meister+Axhausen:2024}{OPSR} was a tracking study
conducted at the Institute for Transport Planning and Systems (IVT) at ETH Zurich.
The data allows researchers to investigate time-use and mobility patterns.
Full data access can be requested via \url{doi:10.3929/ethz-b-000634868}.
}
\details{
The data comprises employed individuals only and is based on valid days only.
A valid day has at least 20h of information where 70\% of the events were
validated by the user. The telework variables are based on tracked work activities.
}
\references{
\insertRef{Winkler+Meister+Axhausen:2024}{OPSR}
}
\keyword{datasets}
