% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{impute.linear}
\alias{impute.linear}
\title{impute missing entries by linear interpolation}
\usage{
impute.linear(x)
}
\arguments{
\item{x}{a numeric data vector, where \eqn{NA} indicates missing
entries. The vector should contain at least two non-missing values.}
}
\value{
a new numeric vector, with the same size of the
original vector, while all the missing entries have been imputed.
}
\description{
This function imputes missing entries in a numeric vector by linear
interpolation.
}
\details{
A missing entry will be imputed by linear interpolation with the two nearest
values before and after it in the vector. When all the values before (after)
it are missing, use the two nearest values after (before) it, instead.
}
\examples{

a=c(NA,NA,3,NA,NA,6,NA,NA)
b=c(1,2,3,4.5,5,NA,6.5,7,NA)

impute.linear(a)
impute.linear(b)

}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
