% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OHPL.RMSEP.R
\name{OHPL.RMSEP}
\alias{OHPL.RMSEP}
\title{Compute RMSEP, MAE, and Q2 for a test set}
\usage{
OHPL.RMSEP(object, newx, newy)
}
\arguments{
\item{object}{Object of class \code{OHPL} fitted by \code{\link[=OHPL]{OHPL()}}.}

\item{newx}{Predictor matrix of the new data.}

\item{newy}{Response matrix of the new data (matrix with one column).}
}
\value{
A list of the performance metrics.
}
\description{
Makes predictions on new data and computes the performance evaluation
metrics RMSEP, MAE, and Q2.
}
\examples{
# Generate simulation data
dat <- OHPL.sim(
  n = 100, p = 100, rho = 0.8,
  coef = rep(1, 10), snr = 3, p.train = 0.5,
  seed = 1010
)

# Split training and test set
x <- dat$x.tr
y <- dat$y.tr
x.test <- dat$x.te
y.test <- dat$y.te

# Fit the OHPL model
fit <- OHPL(x, y, maxcomp = 3, gamma = 0.5, G = 10, type = "max")

# Compute evaluation metric RMSEP, Q2 and MAE for the test set
perf <- OHPL.RMSEP(fit, x.test, y.test)
perf$RMSEP
perf$Q2
perf$MAE
}
