% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pascalau_2007_unit_root.R
\name{Pascalau_2007_unit_root}
\alias{Pascalau_2007_unit_root}
\title{Pascalau(2007) nonlinear unit root test function}
\usage{
Pascalau_2007_unit_root(x, case, max_lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{case}{if raw data 1, if demeaned data 2, if detrended data 3}

\item{max_lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"Test statistic" the value of the test statistic
}
\description{
This function allows you to make Pascalau(2007) nonlinear unit root test
}
\examples{
x <- rnorm(1000)
Pascalau_2007_unit_root(x, case = 1, max_lags = 6, lsm = 2)


y <- cumsum(rnorm(1000))
Pascalau_2007_unit_root(y, 2, 4, 1)


data(IBM)
Pascalau_2007_unit_root(x = IBM, case = 3, max_lags = 3, lsm = 1)


}
\references{
Pascalau, R. (2007). Testing for a unit root in the asymmetric nonlinear smooth transition framework. Department of Economics, Finance and Legal Studies University of Alabama Unpublished manuscript.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
