% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche.Model.Build.R
\name{niche.Model.Build}
\alias{niche.Model.Build}
\title{Ecological niche model building using the randomForest classifier}
\usage{
niche.Model.Build(
  prese = NULL,
  absen = NULL,
  prese.env = NULL,
  absen.env = NULL,
  model = "RF",
  en.vir = NULL,
  bak.vir = NULL
)
}
\arguments{
\item{prese}{Data frame, longitude and latitude of the present data of a
species (can be absent when providing prese.env parameter).}

\item{absen}{Data frame, longitude and latitude of the absent data of a
species.(can be absent when providing absen.env or back parameter).}

\item{prese.env}{Data frame, bioclimate variables of present data.
(can be absent when providing prese parameter).}

\item{absen.env}{Data frame, bioclimate variables of absent data.
(can be absent when providing absen or back parameter).}

\item{model}{Character, string indicating which niche model will be used.
Must be one of "RF" (default) or "MAXENT". "MAXENT" can only be applied when
the java program paste(system.file(package="dismo"), "/java/maxent.jar",
sep='') exists.}

\item{en.vir}{RasterBrick, the global bioclimate data output from
"raster::getData" function.}

\item{bak.vir}{Matrix, bioclimate variables of random background points.}
}
\value{
randomForest/MaxEnt, a trained niche model object.

A vector including the specificity, sensitivity and threshold of the
trained model.
}
\description{
Build a niche model for a given species according to its
distribution data.
}
\examples{
data(en.vir)
data(bak.vir)
#envir<-raster::getData("worldclim",download=FALSE,var="bio",res=2.5)
#en.vir<-raster::brick(envir)
#back<-dismo::randomPoints(mask=en.vir,n=5000,ext=NULL,extf=1.1,
#                          excludep=TRUE,prob=FALSE,
#                          cellnumbers=FALSE,tryf=3,warn=2,
#                          lonlatCorrection=TRUE)
#bak.vir<-raster::extract(en.vir,back)

data<-data.frame(species=rep("Acosmeryx anceus",3),
                 Lon=c(145.380,145.270,135.461),
                 Lat=c(-16.4800,-5.2500,-16.0810))
present.points<-pseudo.present.points(data,10,2,1,en.vir)
NMB.out<-niche.Model.Build(prese=present.points,absen=NULL,
                           prese.env=NULL,absen.env=NULL,
                           model="RF",
                           en.vir=en.vir,bak.vir=bak.vir)
NMB.out


prese.env<-raster::extract(en.vir,present.points[,2:3])
prese.env<-as.data.frame(prese.env)
NMB.out2<-niche.Model.Build(prese=NULL,absen=NULL,
                            prese.env=prese.env,absen.env=NULL,
                            model="RF",
                            en.vir=en.vir,bak.vir=bak.vir)
NMB.out2
}
\references{
Breiman, L. 2001. Random forests. Machine Learning 45(1):5-32.

Liaw, A. and M. Wiener. 2002. Clasification and regression by
randomForest. R News, 2/3:18-22.

Hijmans, R.J., S.E. Cameron, J.L. Parra, P.G. Jones and A. Jarvis.
2005. Very high resolution interpolated climate surfaces for global land areas.
International Journal of Climatology, 25(15):1965-1978.
}
\author{
Cai-qing YANG (Email: yangcq_ivy(at)163.com) and Ai-bing ZHANG
(Email:zhangab2008(at)cnu.edu.cn), Capital Normal University (CNU), Beijing,
CHINA.
}
\keyword{niche.Model.Build}
