% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randnet.R
\name{randnet}
\alias{randnet}
\title{Generates a Random Network}
\usage{
randnet(nodes = NULL, edges = NULL, A = NULL)
}
\arguments{
\item{nodes}{Numeric.
Number of nodes in random network}

\item{edges}{Numeric.
Number of edges in random network}

\item{A}{Matrix or data frame.
An adjacency matrix (i.e., network) to be used to estimated a random network with
fixed edges (allows for asymmetric network estimation)}
}
\value{
Returns an adjacency matrix of a random network
}
\description{
Generates a random binary network
}
\examples{
rand <- randnet(10, 27)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{NeuroImage}, \emph{52}, 1059-1069.

Csardi, G., & Nepusz, T. (2006).
The \emph{igraph} software package for complex network research.
\emph{InterJournal, Complex Systems}, 1695.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
