% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communicability_measures.R
\name{impact_susceptibility}
\alias{impact_susceptibility}
\alias{impact_fluidity}
\alias{impact_diffusion}
\title{Impact Susceptibility, Fluidity and Diffusion}
\usage{
impact_susceptibility(
  exposures,
  buffer,
  weights = NULL,
  terms = Inf,
  sparse = TRUE,
  binary = TRUE,
  exposure_type = c("assets", "liabilities", "impact", "vulnerability")
)

impact_fluidity(
  exposures,
  buffer,
  weights = NULL,
  terms = Inf,
  sparse = TRUE,
  binary = TRUE,
  exposure_type = c("assets", "liabilities", "impact", "vulnerability")
)

impact_diffusion(
  exposures,
  buffer,
  weights = NULL,
  terms = Inf,
  sparse = TRUE,
  binary = TRUE,
  exposure_type = c("assets", "liabilities", "impact", "vulnerability")
)
}
\arguments{
\item{exposures}{an adjacency \code{\link{matrix}}, (sparse) \code{Matrix} or an \code{igraph}
object with the network of bilateral exposures between vertices. By default, the function
expects the exposures in the form of an assets matrix
in which A -> B means that A has an asset with B. However, you can
change that with the parameter \code{exposure_type}. When using a matrix, preferably it should have
rows and columns names.}

\item{buffer}{a numeric vector with the capital buffer for each vertex.
Values should be in the same row/column order as the network of bilateral exposures. The
buffer is not needed if \code{exposure_type = "vulnerability"}.}

\item{weights}{default is \code{NULL}. You can use a numeric
vector of weights to give some economic significance to the measures, like,
for instance, the total assets of the nodes.}

\item{terms}{truncates the communicability matrix evaluation up to a pre-defined number of terms.
If \code{terms = Inf} the function computes the matrix exponential using \code{expm}.}

\item{sparse}{should the function use sparse matrices when computing the communicability? 
However, if \code{terms = Inf}
the function will use \code{expm} which uses \code{dgeMatrix-class}.}

\item{binary}{if \code{binary = TRUE} the function computes a 'binary' impact or vulnerability matrix.
It truncates all values less than 1 to 0 and all values greater than 1 to 1.}

\item{exposure_type}{character vector indicating the type of the bilateral exposures. It can be
an \code{"assets"} network (where A -> B means that A has an asset with B),
a \code{"liabilities"} network (where A -> B means that A has a debt with B),
a (binary) \code{"impact"} matrix (where A -> B indicates the relative impact
 of A in B's capital buffer), or 
a (binary) \code{"vulnerability"} matrix 
(where A -> B indicates the relative impact A suffers from B's default). 
The default is \code{"assets"}.}
}
\value{
The \code{impact_susceptibility} function returns a vector with the (weighted) impact susceptibility

The \code{impact_fluidity} function returns a vector with the (weighted) impact fluidity of the network.

The \code{impact_diffusion} function returns a \code{\link{data.frame}} with
the vertex name and the (weighted) start, intermediate and total impact diffusion.
}
\description{
The \code{impact_susceptibility} measures the
feasible contagion paths that can reach a vertex in relation to its
direct contagion paths. When the impact susceptibility is greater than 1,
it means that the vertex is vulnerable to other vertices beyond its direct
neighbors (remotely vulnerable).

The \code{impact_fluidity} is simply the average of the impact susceptibility in
the network.

The \code{impact_diffusion} tries to capture the influence
exercised by a node on the propagation of impacts in the network. The
impact diffusion of a vertex is measured by the change it causes on the
impact susceptibility of other vertices when its power to
propagate contagion is removed from the network.

All these measures are based on the communicability of the
vulnerability matrix (see \code{\link{vulnerability_matrix}} and
\code{\link{communicability_matrix}}).
}
\examples{
# Creating example data
## Assets Matrix (bilateral exposures)
assets_matrix <- matrix(c(0, 10, 3, 1, 0, 2, 0, 3, 0), ncol = 3)
rownames(assets_matrix) <- colnames(assets_matrix) <- letters[1:3]

## Capital Buffer
buffer <- c(a = 2, b = 5, c = 2)

# Measures
impact_susceptibility(assets_matrix, buffer)
impact_fluidity(assets_matrix, buffer)
impact_diffusion(assets_matrix, buffer)

}
\references{
Silva, T.C.; Souza, S.R.S.; Tabak, B.M. (2015) Monitoring vulnerability and impact
diffusion in financial networks. Working Paper 392, Central Bank of Brazil.

Silva, T.C.; Souza, S.R.S.; Tabak, B.M. (2015) Network structure analysis
of the Brazilian interbank market . Working Paper 391, Central Bank of Brazil.
}
