% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{policies}
\alias{policies}
\alias{policies_metadata}
\title{US State Policy Adoption (SPID)}
\format{The data comes in two objects of class \code{data.frame}. The first
    object, named \code{policies} contains the adoption events. Each row 
    corresponds to an adoption event. Each adoption event is described by 
    the three columns: 
\itemize{
    \item \code{statenam}: Name of the adopting state.
    \item \code{policy}: Name of the policy.
    \item \code{adopt_year}: Year when the state adopted the policy.
}
The second object (\code{policies_metadata}) contains more details on each
of the policies. It contains these columns:
\itemize{
    \item \code{policy}: Name of the policy.
    \item \code{source}: Original source of the data.
    \item \code{first_year}: First year any state adopted this policy.
    \item \code{last_year}: Last year any state adopted this policy.
    \item \code{adopt_count}: Number of states that adopted this policy.
    \item \code{description}: Description of the policy.
    \item \code{majortopic}: Topic group the policy belongs to.
} 
Both \code{data.frame} objects can be joined (merged) on the common column
\code{policy} (see example code).}
\source{
\url{https://doi.org/10.7910/DVN/CVYSR7}
}
\usage{
data(policies)
}
\description{
The SPID data includes information on the year of adoption for over 700 
policies in the American states.
}
\details{
This version 1.0 of the database. For each policy we document the year of first 
adoption for each state. Adoption dates range from 1691 to 2017 and includes 
all fifty states. Policies are adopted by anywhere from 1 to 50 states, with 
an average of 24 adoptions. The data were assembled from a variety of sources, 
including academic publications and policy advocacy/information groups. 
Policies were coded according to the Policy Agendas Project major 
topic code. Additional information on policies is available at the source 
repository.
}
\examples{

data('policies')

# Join the adoption events with the metadata 
merged_policies <- merge(policies, policies_metadata, by = 'policy')
}
\references{
Boehmke, Frederick J.; Mark Brockway; Bruce A. Desmarais; 
    Jeffrey J. Harden; Scott LaCombe; Fridolin Linder; and 
    Hanna Wallach. 2018. "A New Database for Inferring Public Policy 
    Innovativeness and Diffusion Networks." Working paper.
}
\keyword{datasets}
