% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.diffnet}
\alias{plot.diffnet}
\title{Visualize netinf output}
\usage{
\method{plot}{diffnet}(x, type = "network", ...)
}
\arguments{
\item{x}{object of class diffnet to be plotted.}

\item{type}{character, one of \code{c("network", "improvement", "p-value")} 
indicating if the inferred diffusion network, the 
improvement for each edge or the p-value from the vuong test for each
edge should be visualized .}

\item{...}{additional arguments.}
}
\value{
A ggplot plot object if \code{type = "improvement"} otherwise an 
    igraph plot.
}
\description{
Visualize the inferred diffusion network or the marginal gain in fit obtained
by addition of each edge.
}
\details{
If `type = improvement` a ggplot object is returned. It can be modified like
any other ggplot. See the ggplot documentation and the examples in 
\link{plot.cascade}.
}
\examples{

\dontrun{
 data(cascades)
 res <- netinf(cascades, quiet = TRUE)
 plot(res, type = "network")
 plot(res, type = "improvement")
 plot(res, type = "p-value")
}

}
