% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormal.R
\name{ILFLNorm}
\alias{ILFLNorm}
\title{Increased Limit Factor Curve from a LogNormal severity distribution}
\usage{
ILFLNorm(xLow, xHigh, mu, sigma)
}
\arguments{
\item{xLow}{A positive real number -  the claim amount where the Increased Limit Factor Curve will be evaluated from.}

\item{xHigh}{A positive real number -  the claim amount where the Increased Limit Factor Curve will be evaluated to.}

\item{mu}{A real number - the first parameter of the Claim Severity's LogNormal distribution.}

\item{sigma}{A positive real number - the second parameter of the Claim Severity's LogNormal distribution.}
}
\value{
The value of the Increased Limit Factor curve from \code{xLow} to \code{xHigh} with Claim Severity from a LogNormal distribution with parameters \code{mu} and \code{sigma}.
}
\description{
Increased Limit Factor Curve from a LogNormal severity distribution
}
\examples{
ILFLNorm(1000,2000,6,1.5)
ILFLNorm(1000,1500,5,1.6)
}
