% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecological_indices.R
\name{num_species}
\alias{num_species}
\alias{num_species.data.frame}
\alias{num_species.matrix}
\alias{num_species.default}
\title{Calculate Number of Species}
\usage{
num_species(data, ...)

\method{num_species}{data.frame}(data, ...)

\method{num_species}{matrix}(data, ...)

\method{num_species}{default}(data, ...)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix}. The nematode abundance
table where rows represent samples and columns represent nematodes.
Each element indicates the count of a specific nematode in the
corresponding sample. Row names must be sample names.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A \code{data.frame} with two columns:
\item{Sample.ID}{Character vector of sample identifiers (from row names)}
\item{NumSpecies}{Number of non-zero nematode species in each sample}
}
\description{
This function calculates the number of nematode species present in each sample.
It counts the number of non-zero and non-empty nematode species for each sample.
}
\examples{
# Example with a data frame
df <- data.frame(
  Species1 = c(10, NA, 15),
  Species2 = c(5, 10, NA),
  Species3 = c(8, 12, 10),
  row.names = c("A", "B", "C")
)
num_species(df)

# Example with a matrix
mat <- matrix(c(10, NA, 15, 5, 10, NA, 8, 12, 10), nrow = 3, byrow = TRUE)
colnames(mat) <- c("Species1", "Species2", "Species3")
row.names(mat) <- c("A", "B", "C")
num_species(mat)

}
