% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NatParksPalettes.R
\name{scale_colour_natparks_d}
\alias{scale_colour_natparks_d}
\title{NatParksPalettes for plotting with ggplot2}
\usage{
scale_colour_natparks_d(name, direction = 1, override.order = FALSE, ...)
}
\arguments{
\item{name}{Name of Palette. Choices are:
\code{Acadia}, \code{Arches}, \code{Arches2}, \code{Banff}, \code{Bryce Canyon},
\code{CapitolReef}, \code{Charmonix}, \code{Cuyahoga}, \code{DeathValley}, \code{Denali}, 
\code{Everglades}, \code{Glacier}, \code{GrandCanyon}, \code{Halekala}, \code{IguazuFalls}, 
\code{KingsCanyon}, \code{LakeNakuru}, \code{Olympic}, \code{Redwood}, \code{RockyMtn}, 
\code{Saguaro}, \code{SmokyMtns}, \code{SouthDowns}, \code{Torres}, \code{Triglav}, 
\code{WindCave}, \code{Volcanoes},  \code{Yellowstone}, and \code{Yosemite}.}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1, palette color order is reversed}

\item{override.order}{Colors are picked from palette to maximize readability and aesthetics. This means
that colors are not always selected in sequential order from the full palette. If override.order is set to TRUE,
colors are selected in sequential order from the full palette instead. Default is FALSE.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{discrete_scale}}}
}
\value{
A function that returns a discrete colour scale.
}
\description{
Function for using \code{NatParksPalettes} colors schemes in \code{ggplot2}. Use \code{\link{scale_color_natparks_d}} and \code{\link{scale_fill_natparks_d}}
for discrete scales and \code{\link{scale_color_natparks_c}} and \code{\link{scale_fill_natparks_c}} for continuous scales.
}
\examples{
library(ggplot2)
ggplot(data=iris, aes(x=Sepal.Length, y=Sepal.Width, color=Species)) +
geom_point() +
scale_colour_natparks_d("Yellowstone")
}
