% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR.R
\name{QR}
\alias{QR}
\title{Refine the Q-matrix by Minimizing the RSS}
\usage{
QR(Y, Q, gate = c("AND", "OR"), max.ite = 50)
}
\arguments{
\item{Y}{A matrix of binary responses (1=correct, 0=incorrect). Rows
represent persons and columns represent items.}

\item{Q}{The Q-matrix of the test. Rows represent items and columns
represent attributes.}

\item{gate}{A string, "AND" or "OR". "AND": the examinee needs to possess
all related attributes to answer an item correctly.
"OR": the examinee needs to possess only one of the related attributes
to answer an item correctly.}

\item{max.ite}{The number of iterations to run until all RSS of all items
are stationary.}
}
\value{
A list containing:
\item{initial.class}{Initial classification}
\item{terminal.class}{Terminal classification}
\item{modified.Q}{The modified Q-matrix}
\item{modified.entries}{The modified q-entries}
}
\description{
We estimate memberships using the non-parametric classification
method (weighted hamming), and comparisons of the residual sum of squares
computed from the observed and the ideal item responses.
}
\section{The Q-Matrix Refinment (QR) Method}{


This function implements the Q-matrix refinement method developed by Chiu
(2013), which is also based on the aforementioned nonparametric classification
methods (Chiu & Douglas, 2013). This Q-matrix refinement method corrects
potential misspecified entries of the Q-matrix through comparisons of the
residual sum of squares computed from the observed and the ideal item responses.

The algorithm operates by minimizing the RSS. Recall that \eqn{Y_{ij}} is the
observed response and \eqn{\eta_{ij}} is the ideal response.
Then the RSS of item \eqn{j} for examinee \eqn{i} is defined as
\deqn{RSS_{ij} = (Y_{ij} - \eta_{ij})^2}.
The RSS of item \eqn{j} across all examinees is therefor
\deqn{RSS_{j} = \sum_{i=1}^{N} (Y_{ij} - \eta_{ij})^2 = \sum_{m=1}^{2^k} \sum_{i \in C_{m}} (Y_{ij} - \eta_{jm})^2}
where \eqn{C_m} is the latent proficiency-class \eqn{m}, and \eqn{N}
is the number of examinees. Chiu(2013) proved that the expectation of
\eqn{RSS_j} is minimized for the correct q-vector among the
\eqn{2^K - 1} candidates. Please see the paper for the justification.
}

\references{
Chiu, C. Y. (2013). Statistical Refinement of the Q-matrix in Cognitive Diagnosis. \emph{Applied Psychological Measurement, 37(8)}, 598-618.
}
