% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Isoplot.R
\name{Isoplot}
\alias{Isoplot}
\title{Create plot(s) of the observations, the sample means and the fitted isotonic
regression curve}
\usage{
Isoplot(data.nm, data.control, id, nano, response, dose, end, end.cat,
  unit, unit.cat, dose.type=c("dose","log"), type = c("continuous",
  "ordinal"), control.opt=c("same","all"), add.curve = TRUE, vars, nrow=1,
  ncol=1, xlabel="Dose", ylabel="Response")
}
\arguments{
\item{data.nm}{Data containing the result of toxicity study}

\item{data.control}{Data of control values}

\item{id}{Identifier of the experiment}

\item{nano}{Name of the nanomaterial}

\item{response}{Response (endpoint value)}

\item{dose}{Dose or concentration}

\item{end}{Toxicity endpoint}

\item{end.cat}{Specific toxicity endpoint of interest}

\item{unit}{Unit of measurement of the dose}

\item{unit.cat}{Specific unit of measurement of the dose}

\item{dose.type}{Type of the dose to be plotted ("dose" for dose and "log"
for log(dose))}

\item{type}{Type of the dose (continuous or ordinal)}

\item{control.opt}{Option for the control doses if \code{unit} and
\code{unit.cat} are specified. If only control doses with the same unit of
measurement as the non-control ones are included, then specify
"\code{same}" in the \code{control.opt}. If all control doses with any
units of measurement are included, then specify "\code{all}".}

\item{add.curve}{Adding curve to the plot}

\item{vars}{Variable(s) used to subset the data}

\item{nrow}{Number of row in the plotting space}

\item{ncol}{Number of column in the plotting space}

\item{xlabel}{Label for x-axis}

\item{ylabel}{Label for y-axis}
}
\value{
This function produces plot(s) consisting of observation data points,
  sample mean for each dose and fitted isotonic regression curve
}
\description{
This function creates plot(s) of the observations, the sample means and the
fitted isotonic regression curve for one or more nanomaterials simultaneously
}
\details{
\itemize{
\item{This function performs data exploration for each nanomaterial in the
dataset (or for each subset of data). The different types of nanomaterials
are identified by their names. Therefore, if some control values are named
differently (see: \code{\link{geninvitro}} dataset and the \code{Examples}),
a separate dataset containing only these values first needs to be created.
Controls in the new dataset can be linked to the non-control observations
belonging to the same experiment through the identifier of the experiment
(the linking is performed inside this function). In this situation, it is
necessary to have an indicator that can identify different experiments (such
as experiment ID).}
\item{If all controls in the dataset are named according to the related
nanomaterial names, \code{data.control} and \code{id} do not need to be
specified.}
\item{If doses used in the experiment are all measured in the same unit of
measurement, then specify "\code{same}" in \code{control.opt}}.
\item{Dose-response plot can also be generated for subsets of data in each
nanomaterial by specifying the variables used to split the data in
\code{vars}}.
}
}
\examples{
# Example 1:
# Create a dataset containing controls (which are named differently)
# from geninvitro dataset:
controldata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"))

# Exclude controls (which are named differently) from geninvitro dataset:
invitrodata<-SubsetData(data=geninvitro, x="name", x.cat=c("control", "Control",
             "medium", "medium + BSA", "untreated"), include=FALSE)
#
# Generate dose-response plots for geninvitro, with DNA STRAND BREAKS
# as the endpoint, concentrations measured in "ug/cm2"
# and control doses measured in any units of measurement:
#
\donttest{Isoplot(data.nm=invitrodata, data.control=controldata, id="experimentID",
        nano="name", response="value", dose="concentration", end="endpoint",
        end.cat="DNA STRAND BREAKS", unit="concentration_unit", unit.cat="ug/cm2",
        dose.type="dose", control.opt="all")}

# Example 2:
# Split geninvitro data according to the cell type, method, study provider and
# unit of the concentration and generate dose-response plot for each subset
# of data with DNA STRAND BREAKS as the endpoint:
#
\donttest{Isoplot(data.nm=invitrodata, data.control=controldata, id="experimentID",
        nano="name", response="value", dose="concentration", end="endpoint",
        end.cat="DNA STRAND BREAKS",  dose.type="dose",
        vars=c("celltype","method","studyprovider","concentration_unit"),
        nrow=2, ncol=2)}

}
\references{
Lin D., Pramana, S., Verbeke, T., and Shkedy, Z. (2015). IsoGene:
  Order-Restricted Inference for Microarray Experiments. R package version
  1.0-24. \url{https://CRAN.R-project.org/package=IsoGene}

  Lin D., Shkedy Z., Yekutieli D., Amaratunga D., and Bijnens, L. (editors).
  (2012) Modeling Doseresponse Microarray Data in Early Drug Development
  Experiments Using R. Springer.
}
