% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/down_distance_updater.R
\name{down_distance_updater}
\alias{down_distance_updater}
\title{Update the down and distance of a drive}
\usage{
down_distance_updater(
  what_down,
  yards_to_go,
  yards_from_own_goal,
  play_by_play_data,
  ...
)
}
\arguments{
\item{what_down}{The current down (1st, 2nd, 3rd, or 4th down)}

\item{yards_to_go}{Number of yards to go until a first down or TD}

\item{yards_from_own_goal}{The number of yards from the possession team's own goal}

\item{play_by_play_data}{A data file from nflscrapR prepped using the prep_pbp_data.R function}

\item{...}{Additional arguments for different strategies}
}
\value{
A data.frame object
}
\description{
The down and distance updater will run a play and update various game-based
statistics accordingly.
}
\examples{
\dontrun{
down_distance_updater(what_down = 1,
                      yards_to_go = 10,
                      yards_from_own_goal = 25,
                      play_by_play_data = pbp_data,
                      strategy = "normal")
} 

}
