% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copulaEmp.R
\name{copulaEmp}
\alias{copulaEmp}
\title{Empirical copula}
\usage{
copulaEmp(u, U)
}
\arguments{
\item{u}{(nx2) data matrix of points.}

\item{U}{(nx2) data matrix of pseudo-observations.}
}
\value{
\item{cdf}{Empirical copula values at u.}
}
\description{
This function computes the  empirical bivariate copula at a series of points.
}
\examples{
param <- c(0.8, 2.5, 0.7) ;
U <- SimNCSCop('Clayton', 250, param)
u = matrix(c(0.2,0.6,0.3,0.5,0.7,0.9),ncol=2,byrow=TRUE);
cdf=copulaEmp(u,U);

}
\author{
Bouchra R. Nasri, August 14, 2019
}
