% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADF_IC.R
\name{ADF_IC}
\alias{ADF_IC}
\title{Augmented Dickey-Fuller Statistic by AIC or BIC}
\usage{
ADF_IC(y, adflag, mflag, IC)
}
\arguments{
\item{y}{the time series to be used.}

\item{adflag}{the maximum lag order.}

\item{mflag}{1 for ADF with constant and whithout trend, 2 for ADF with constant and trend and 3 for ADF without constant and trend.}

\item{IC}{1 for AIC and 2 for BIC.}
}
\description{
Calculate the Augmented Dickey-Fuller Statistic with lag order selected by AIC or BIC.
}
\examples{
y <- rnorm(10)
ADF_IC(y, adflag = 1, mflag = 2, IC = 1)
ADF_IC(y, adflag = 1, mflag = 2, IC = 2)

}
\references{
Phillips, P.C. & Shi, S. & Yu, J. (2013). "Testing for Multiple Bubbles: Historical Episodes of Exuberance and Collapse in the S&P 500". \emph{SSRN Electronic Journal}.
}
\keyword{AugmentedDickey-FullerTest.}
