% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/submitModels.R
\name{submitModels}
\alias{submitModels}
\title{Submit Mplus models to a high-performance cluster scheduler}
\usage{
submitModels(
  target = getwd(),
  recursive = FALSE,
  filefilter = NULL,
  replaceOutfile = "modifiedDate",
  Mplus_command = NULL,
  quiet = FALSE,
  scheduler = "slurm",
  sched_args = NULL,
  env_variables = NULL,
  export_all = FALSE,
  cores_per_model = 1L,
  memgb_per_model = 8L,
  time_per_model = "1:00:00",
  pre = NULL,
  post = NULL,
  batch_outdir = NULL,
  job_script_prefix = NULL,
  combine_jobs = TRUE,
  max_time_per_job = "24:00:00",
  combine_memgb_tolerance = 1,
  combine_cores_tolerance = 2,
  debug = FALSE,
  fail_on_error = TRUE
)
}
\arguments{
\item{target}{a character vector where each element is a directory containing Mplus input files
(.inp) to run OR a single .inp file to be run. Elements may be a full path, relative path,
or a filename within the working directory.
Defaults to the current working directory. Example: \dQuote{C:/Users/Michael/Mplus Runs}}

\item{recursive}{optional. If \code{TRUE}, run all models nested in subdirectories
within \code{directory}. Defaults to \code{FALSE}. Not relevant if \code{target} is a single file.}

\item{filefilter}{a Perl regular expression (PCRE-compatible) specifying particular input
files to be run among those found in \code{target}. See \code{regex} or \url{https://www.pcre.org/pcre.txt}
for details about regular expression syntax.}

\item{replaceOutfile}{optional. Currently supports three settings: \dQuote{always}, which
runs all models, regardless of whether an output file for the model exists; \dQuote{never},
which does not run any model that has an existing output file; and \dQuote{modifiedDate}, which
only runs a model if the modified date for the input file is more recent than
the output file modified date (implying there have been updates to the model).}

\item{Mplus_command}{optional. N.B.: No need to pass this parameter for most users (has intelligent
defaults). Allows the user to specify the name/path of the Mplus executable to be used for
running models. This covers situations where Mplus is not in the system's path,
or where one wants to test different versions of the Mplus program.}

\item{quiet}{optional. If \code{FALSE}, show status messages in the console.}

\item{scheduler}{Which scheduler to use for job submission. Options are 'qsub', 'torque', 'sbatch', 'slurm', 'local', or 'sh'.
The terms \code{'qsub'} and \code{'torque'} are aliases (where 'torque' submits via the qsub command). Likewise for 'sbatch'
and 'slurm'. If \code{'local'} or  \code{'sh'} are specified, \code{submitModels} does not submit to any scheduler at all,
but instead executes the command locally via a shell script.}

\item{sched_args}{A character vector of arguments to be included in the scheduling command. On TORQUE, these
will typically begin with '-l' such as '-l wall_time=10:00:00'. These are added inside the submission script
for each model and are shared across all models. To add model-specific arguments, include \verb{! #SBATCH} or
\verb{! #PBS} lines inside the individual .inp files}

\item{env_variables}{A named character vector containing environment variables and their values to be passed
to the \code{script} at execution time. This is handled by the \code{-v} directive on TORQUE clusters and
by \code{--export} on Slurm clusters. The names of this vector are the environment variable names and
the values of the vector are the environment variable values to be passed in.
If you want to propagate the current value of an environment variable to the compute node at runtime,
use NA as the value of the element in \code{env_variables}. See examples.}

\item{export_all}{Whether to export all environment variables to the compute node at runtime. Default: FALSE}

\item{cores_per_model}{How many cpus/cores are requested for each model (can be overriden using \code{! BATCH} directives in .inp files).
Default: 1.}

\item{memgb_per_model}{amount of memory (RAM) requested for each model (in GB). Default: 8.}

\item{time_per_model}{amount of time requested for each model. Default: "1:00:00" (1 hour). If
a number is provided, we will treat this as the number of minutes.}

\item{pre}{user-specified shell commands  to include in the job script prior to running Mplus (e.g., module load commands)}

\item{post}{user-specified shell commands to include in the job script after Mplus runs (e.g., execute results wrangling script)}

\item{batch_outdir}{the directory where job scripts should be written}

\item{job_script_prefix}{the filename prefix for each job script}

\item{combine_jobs}{if TRUE, \code{submitModels} will seek to combine similar models into batches to reduce the total number of jobs}

\item{max_time_per_job}{The maximum time (in days-hours:minutes:seconds format) allowed for a combined job}

\item{combine_memgb_tolerance}{The memory tolerance for combining similar models in GB. Defaults to 1 (i.e., models that differ by <= 1 GB can be combined)}

\item{combine_cores_tolerance}{The cores tolerance for combining models with similar core requests. Defaults to 2 (i.e., models whose core requests differ by <= 2 can be combined)}

\item{debug}{a logical indicating whether to actually submit the jobs (TRUE) or just create the scripts for inspection (FALSE)}

\item{fail_on_error}{Whether to stop execution of the script (TRUE), or issue a warning (FALSE) if the job
submission fails. Defaults to TRUE.}
}
\value{
A data.frame recording details of the jobs submitted by \code{submitModels}. This can be passed to the \code{summary} function
or to \code{checkSubmission} to see the state of submitted jobs.
}
\description{
This function submits a group of Mplus models (.inp files) located within a
single directory or nested within subdirectories.
}
\details{
Note that if \code{fail_on_error} is \code{TRUE} and submission of one model fails, the submission loop will stop, rather than
submitting further models.
}
\examples{
\dontrun{
  submitModels("~/Michael/submitTest", recursive=TRUE, sched_args=c("--mail=user", "--export=v"), 
    max_time_per_job = "2:10:00", combine_jobs = TRUE)
}
}
\author{
Michael Hallquist
}
