% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setLoading.R
\name{setLoading}
\alias{setLoading}
\alias{setLoading,mortalityTable-method}
\title{Return a copy of the table with an additional loading added}
\usage{
setLoading(object, loading = 0)

\S4method{setLoading}{mortalityTable}(object, loading = 0)
}
\arguments{
\item{object}{A life table object (instance of a \code{mortalityTable} class)}

\item{loading}{The additional (security) loading to be added to the table.}
}
\description{
Return a copy of the table with an additional loading added
}
\section{Methods (by class)}{
\itemize{
\item \code{setLoading(mortalityTable)}: Return the life table with the given loading set

}}
\examples{
mortalityTables.load("Austria_Census")
# Austrian census mortality 2011 reduced by 30\%
setLoading(mort.AT.census.2011.male, loading = -0.3)

}
