% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsegreg.R
\name{plotsegreg}
\alias{plotsegreg}
\alias{plotsegreg.regions_pco}
\alias{plotsegreg.regions_sim}
\alias{plotsegreg.regions_results_single}
\title{Plot a segmented regression model}
\usage{
plotsegreg(x, scores, ...)

\method{plotsegreg}{regions_pco}(
  x,
  scores,
  modelsupport = NULL,
  criterion = "aic",
  model = 1,
  bps = NULL,
  cont = TRUE,
  ...
)

\method{plotsegreg}{regions_sim}(
  x,
  scores,
  modelsupport = NULL,
  criterion = "aic",
  model = 1,
  bps = NULL,
  cont = TRUE,
  ...
)

\method{plotsegreg}{regions_results_single}(x, scores, ...)
}
\arguments{
\item{x}{a \code{regions_pco} object, the output of a call to \code{\link[=svdPCO]{svdPCO()}}, or a \code{regions_results_single} object, the output of a call to \code{\link[=calcmodel]{calcmodel()}}.}

\item{scores}{\code{numeric}; the indices of the PCO scores for which the fitted lines should be plotted.}

\item{\dots}{ignored.}

\item{modelsupport}{a \code{regions_modelsupport} object, the output of a call to \code{\link[=modelsupport]{modelsupport()}}. When \code{x} is a \code{regions_pco} object, either \code{modelsupport}, \code{criterion}, and \code{model} must be supplied or \code{bps} and \code{cont} must be supplied. See Details.}

\item{criterion}{string; the criterion to use to select the best model for which breakpoints are to be displayed when \code{modelsupport} is specified. Ignored otherwise. Allowable options include \code{"aic"} to use the AICc and \code{"bic"} to use the BIC. Abbreviations allowed. Default is \code{"aic"}. When \code{x} is a \code{regions_pco} object, either \code{modelsupport}, \code{criterion}, and \code{model} must be supplied or \code{bps} and \code{cont} must be supplied. See Details.}

\item{model}{\code{numeric}; for which model among the best as determined by \code{criterion} should fitted lines be plotted. 1 is the best model, 2 the second best, etc. Default is 1. When \code{x} is a \code{regions_pco} object, either \code{modelsupport}, \code{criterion}, and \code{model} must be supplied or \code{bps} and \code{cont} must be supplied. See Details.}

\item{bps}{\code{numeric}; a vector of breakpoints for which model fitted lines should be plotted. When \code{x} is a \code{regions_pco} object, either \code{modelsupport}, \code{criterion}, and \code{model} must be supplied or \code{bps} and \code{cont} must be supplied. See Details.}

\item{cont}{\code{logical}; whether to fit a model that is continuous (\code{TRUE}) or discontinuous (\code{FALSE}) at the breakpoints supplied to \code{bps}. Default is \code{TRUE}. When \code{x} is a \code{regions_pco} object, either \code{modelsupport}, \code{criterion}, and \code{model} must be supplied or \code{bps} and \code{cont} must be supplied. See Details.}
}
\value{
A \code{ggplot} object that can be manipulated using \emph{ggplot2} syntax.
}
\description{
\code{plotsegreg()} plots the fitted lines resulting from a segmented regression model.
}
\details{
\code{plotsegreg()} operates on a single model identified by breakpoints and whether the model is continuous or not. When \code{x} is a \code{regions_pco} object, the model is selected either as the best model in the supplied \code{modelsupport} object (where "best" is determined by the arguments to \code{criterion} and \code{model}) or as specified by the user using the arguments to \code{bps} and \code{cont}. When \code{x} is a \code{regions_results_single} object, the breakpoints and model form are determined based on the supplied object.

\code{plot()} is an alias for \code{plotsegreg()} for \code{regions_results_single} objects.
}
\examples{
data("alligator")

alligator_data <- process_measurements(alligator,
                                       pos = "Vertebra")

# Compute PCOs
alligator_PCO <- svdPCO(alligator_data)

# Evaluate model performance (R2) given supplied
# breakpoints for a continuous model
modelperf(alligator_PCO, scores = 1:3,
          bps = c(7, 15, 20), cont = TRUE)

plotsegreg(alligator_PCO, scores = 1:3,
           bps = c(7, 15, 20), cont = TRUE)
## See also `?calcmodel` for use with a single model

# Fit segmented regression models for 1 to 7 regions
# using PCOs 1 to 4 and a continuous model with a
# non-exhaustive search
regionresults <- calcregions(alligator_PCO,
                             scores = 1:4,
                             noregions = 7,
                             minvert = 3,
                             cont = TRUE,
                             exhaus = FALSE,
                             verbose = FALSE)

regionresults

# For each number of regions, identify best
# model based on minimizing RSS
bestresults <- modelselect(regionresults)

# Evaluate support for each model and rank
supp <- modelsupport(bestresults)

# Evaluate model performance (R2) for best model
# as chosen by BIC
modelperf(alligator_PCO, scores = 1:4,
          modelsupport = supp,
          criterion = "bic", model = 1)

# Plot that model for the first PCO score
plotsegreg(alligator_PCO, scores = 1:4,
           modelsupport = supp,
           criterion = "bic", model = 1)

## See `?simregions` for use with simulated data
}
\seealso{
\code{\link[=modelsupport]{modelsupport()}} for assessing model support using information criteria; \code{\link[=calcmodel]{calcmodel()}} for fitting a single segmented regression model; \code{\link[=modelperf]{modelperf()}} for computing fit statistics for a single segmented regression model.
}
