% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-validate.R
\name{verify}
\alias{verify}
\title{Validates Coo objects}
\usage{
verify(Coo)
}
\arguments{
\item{Coo}{any Coo object}
}
\value{
a Coo object.
}
\description{
No validation for S3 objects, so this method is a (cheap) attempt at checking
\link{Coo} objects, \link{Out}, \link{Opn} and \link{Ldk} objects.
}
\details{
Implemented before all morphometric methods and handling verbs.
To see what is checked, try eg \code{Momocs:::verify.Coo}
}
\examples{
verify(bot)
bot[12] <- NA
# you would not use try, but here we cope with R CMD CHECK standards
plop <- try(verify(bot), silent=TRUE)
class(plop)

verify(hearts)
hearts$ldk[[4]] <- c(1, 2)
# same remark
plop2 <- try(verify(hearts), silent=TRUE)
class(plop2)
}
