% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_angle_tangent}
\alias{coo_angle_tangent}
\alias{coo_angle_tangent.default}
\alias{coo_angle_tangent.Coo}
\alias{coo_tangle}
\title{Calculates the tangent angle along the perimeter of a
shape}
\usage{
coo_angle_tangent(coo)

\method{coo_angle_tangent}{default}(coo)

\method{coo_angle_tangent}{Coo}(coo)

coo_tangle(coo)
}
\arguments{
\item{coo}{a matrix of coordinates or any \code{Coo}}
}
\value{
\code{numeric}, the tangent angle along the perimeter, or a
\code{list} of those for \code{Coo}
}
\description{
Calculated using complex numbers and returned in radians
minus the first one (modulo 2*pi).
}
\examples{
b <- bot[1]
phi  <- coo_angle_tangent(b)
phi2 <- coo_angle_tangent(coo_smooth(b, 2))
plot(phi, type='l')
plot(phi2, type='l', col='red') # ta is very sensible to noise

# on Coo
bot \%>\% coo_angle_tangent
}
\seealso{
\link{tfourier}

Other coo_ descriptors: 
\code{\link{coo_angle_edges}()},
\code{\link{coo_area}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_chull}()},
\code{\link{coo_circularity}()},
\code{\link{coo_convexity}()},
\code{\link{coo_eccentricity}},
\code{\link{coo_elongation}()},
\code{\link{coo_length}()},
\code{\link{coo_lw}()},
\code{\link{coo_rectangularity}()},
\code{\link{coo_rectilinearity}()},
\code{\link{coo_scalars}()},
\code{\link{coo_solidity}()},
\code{\link{coo_tac}()},
\code{\link{coo_width}()}
}
\concept{coo_ descriptors}
