% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional.R
\name{BICMultiFunctions}
\alias{BICMultiFunctions}
\title{BIC score for multiple functions}
\usage{
BICMultiFunctions(Px, X)
}
\arguments{
\item{Px}{A list of objects of class \code{"motbf"}.}

\item{X}{A list with as many \code{"numeric"} vectors as densities in \code{Px},
used to compute the BIC score for each density.}
}
\value{
The \code{"numeric"} BIC value.
}
\description{
Compute the BIC score using more than one probability functions.
}
\examples{
## Data
X <- rnorm(500)
Y <- rnorm(500, mean=1)
data <- data.frame(X=X, Y=Y)
## Data as a "list"
Xlist <- sapply(data, list)

## Learning as a "list"
Plist <- lapply(data, univMoTBF, POTENTIAL_TYPE="MOP")
Plist

## BIC value
BICMultiFunctions(Px=Plist, X=Xlist)

}
\seealso{
\link{univMoTBF}
}
