% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.estimate.add.R
\name{effect.estimate.add}
\alias{effect.estimate.add}
\title{Estimation of marker effects}
\usage{
effect.estimate.add(geno, pheno, map = NULL, scaling = TRUE)
}
\arguments{
\item{geno}{genotype dataset (marker x individuals)}

\item{pheno}{phenotype dataset (each phenotype in a row)}

\item{map}{genomic map}

\item{scaling}{Set FALSE to not perform variance scaling}
}
\value{
Empirical kinship matrix (IBD-based since Founders)
}
\description{
Function to estimate marker effects
}
\examples{
data(ex_pop)
pheno <- get.pheno(ex_pop, gen=1:5)
geno <- get.geno(ex_pop, gen=1:5)
map <- get.map(ex_pop, use.snp.nr=TRUE)
\donttest{real.bv.add <- effect.estimate.add(geno, pheno, map)}
}
