% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_continuous_var.R
\name{plot_continuous_var}
\alias{plot_continuous_var}
\title{Plot proportions by a continuous covariate}
\usage{
plot_continuous_var(
  jags.1,
  mix,
  source,
  output_options,
  alphaCI = 0.05,
  exclude_sources_below = 0.1
)
}
\arguments{
\item{jags.1}{output from \code{\link{run_model}}}

\item{mix}{output from \code{\link{load_mix_data}}}

\item{source}{output from \code{\link{load_source_data}}}

\item{output_options}{list containing options for plots and saving, passed from \code{\link{output_JAGS}}}

\item{alphaCI}{alpha level for credible intervals (default = 0.05, 95\% CI)}

\item{exclude_sources_below}{don't plot sources with median proportion below this level for entire range of continuous effect variable (default = 0.1)}
}
\description{
\code{plot_continuous_var} creates a plot of how the mixture proportions
change according to a continuous covariate, as well as plots of the mixture
proportions for the individuals with minimum, median, and maximum covariate
values. Called by \code{\link{output_JAGS}} if any continuous effects are in
the model.
}
\details{
MixSIAR fits a continuous covariate as a linear regression in ILR/transform-space.
Two terms are fit for the proportion of each source: an intercept and a slope.
The plotted line uses the posterior median estimates of the intercept and slope, and
the lines are curved because of the ILR-transform back into proportion-space. The 
95\% credible intervals are shaded.

If the model contains both a continuous AND a categorical (factor) covariate, MixSIAR
fits a different intercept term for each factor level and all levels share the
same slope term.
}
\seealso{
Francis et al. 2011
}
