% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MittagLeffleR.R
\docType{package}
\name{MittagLeffleR-package}
\alias{MittagLeffleR}
\alias{MittagLeffleR-package}
\title{Mittag-Leffler family of distributions}
\description{
A generalization of the exponential distribution. Contains 
\itemize{
\item 
the Mittag-Leffler function \code{\link{mlf}}
\item 
distributions (\code{\link{dml}}, \code{\link{pml}}, \code{\link{qml}}) 
and random variate generation (\code{\link{rml}})
\item
a log-moment estimator (\code{\link{logMomentEstimator}}), 
and maximum likelihood estimator (\code{\link{mlmle}})
}
}
\details{
\itemize{
  \item 
  \href{https://strakaps.github.io/MittagLeffleR/articles/MLdist.html}{Plots of the Mittag-Leffler distributions}
  \item 
  \href{https://strakaps.github.io/MittagLeffleR/articles/parametrisation.html}{Details of Mittag-Leffler random variate generation}
  \item 
  \href{https://strakaps.github.io/MittagLeffleR/articles/probsNquantiles.html}{Probabilities and Quantiles}
}
Also see the package web page at 
\url{https://strakaps.github.io/MittagLeffleR/reference/index.html}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://strakaps.github.io/MittagLeffleR/}
  \item Report bugs at \url{https://github.com/strakaps/MittagLeffleR/issues}
}

}
\author{
\strong{Maintainer}: Peter Straka \email{straka.ps@gmail.com}

Authors:
\itemize{
  \item Katharina Hees \email{heeskatharina@gmail.com}
  \item Gurtek Gill
}

Other contributors:
\itemize{
  \item Roberto Garrappa \email{roberto.garrappa@uniba.it} [contributor]
}

}
